DESCRIPTION="The"

EXT_VERSION=$(basename $PKG_GPM tar.bz2 | cut -d "-" -f 2) 

if [ -f ../$(basename $PATCH_GPM) ]; then
	patch -Np1 -i ../$(basename $PATCH_GPM)
fi

GCC15=false
[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] && GCC15=true

if [[ $GCC15 ]] && [ -f ../$(basename $PATCH_GCC15) ]; then
	patch -Np1 -i ../$(basename $PATCH_GCC15)
fi

./autogen.sh                                                    &&
./configure --prefix=/usr --sysconfdir=/etc ac_cv_path_emacs=no &&
make

if [[ $(command -v texdoc) != "" ]]; then 
	make -C doc gpm.{dvi,ps} &&
	dvipdfm doc/gpm.dvi -o doc/gpm.pdf
fi

# As root:
make install                                          &&

install-info --dir-file=/usr/share/info/dir           \
             /usr/share/info/gpm.info                 &&

rm -fv /usr/lib/libgpm.a
[ -h /usr/lib/libgpm.so ] && unlink /usr/lib/libgpm.so
ln -sfv libgpm.so.2.1.0 /usr/lib/libgpm.so            &&
install -v -m644 conf/gpm-root.conf /etc              &&

install -v -m755 -d /usr/share/doc/gpm-${EXT_VERSION}/support &&
install -v -m644    doc/support/*                     \
                    /usr/share/doc/gpm-${EXT_VERSION}/support &&
install -v -m644    doc/{FAQ,HACK_GPM,README*}        \
                    /usr/share/doc/gpm-${EXT_VERSION}

[[ $(command -v texdoc) != "" ]] && install -vm644 doc/gpm.{dvi,ps,pdf} /usr/share/doc/gpm-${EXT_VERSION}

update_version_list $PKG_GPM
