DESCRIPTION="The glslc program is Google's command line compiler for OpenGL Shading Language/High Level Shading Language (GLSL/HLSL) to Standard Portable Intermediate Representation (SPIR-V)."

EXT_VERSION=$(basename $PKG_GLSLC .tar.gz | cut -d "-" -f 2) 

sed '/build-version/d'   -i glslc/CMakeLists.txt            &&
sed '/third_party/d'     -i CMakeLists.txt                  &&
sed 's|SPIRV|glslang/&|' -i libshaderc_util/src/compiler.cc &&

echo '"2024.4"' > glslc/src/build-version.inc

mkdir build &&
cd    build &&

cmake -D CMAKE_INSTALL_PREFIX=/usr \
      -D CMAKE_BUILD_TYPE=Release  \
      -D SHADERC_SKIP_TESTS=ON     \
      -G Ninja ..
ninja

# As root:
install -vm755 glslc/glslc /usr/bin

update_version_list $PKG_GLSLC
