DESCRIPTION="The Glslang package contains an frontend and validator for OpenGL, OpenGL ES, and Vulkan shaders."
# Glslang
# The Glslang package contains an frontend and validator for OpenGL, OpenGL ES, and Vulkan shaders.

# Contents
# Installed Programs: glslang, glslang-validator (symlink to glslang), and spirv-remap
# Installed Libraries: libglslang.so, libglslang-default-resource-limits.so, libSPIRV.so, and libSPVRemapper.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/glslang and /usr/lib/cmake/glslang

# Short Descriptions
# glslang - provides a front end and validator for OpenGL, OpenGL ES, and Vulkan shaders
# libglslang.so - contains functions that provide a front-end and validator for OpenGL, OpenGL ES, and Vulkan shaders to other programs
# libSPIRV.so - provides a front-end and generator for SPIR-V binaries
# libSPVRemapper.so - provides a remapper for SPIR-V binaries

# Required
# CMake-3.31.6 and SPIRV-Tools-1.4.304.1

# Recommended
# None

# Optional
# None

#EXT_VERSION=$(basename $PKG_GLSLANG .tar.gz | cut -d "-" -f 2)

mkdir build &&
cd    build &&

cmake -D CMAKE_INSTALL_PREFIX=/usr     \
      -D CMAKE_BUILD_TYPE=Release      \
      -D ALLOW_EXTERNAL_SPIRV_TOOLS=ON \
      -D BUILD_SHARED_LIBS=ON          \
      -D GLSLANG_TESTS=ON              \
      -G Ninja .. &&
ninja

ninja install

if $MULTILIB
then
	rm -rf *
	CC="gcc -m32" CXX="g++ -m32"           \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig   \
	cmake -D CMAKE_INSTALL_PREFIX=/usr     \
		  -D CMAKE_INSTALL_LIBDIR=lib32    \
		  -D CMAKE_BUILD_TYPE=Release      \
		  -D ALLOW_EXTERNAL_SPIRV_TOOLS=ON \
		  -D BUILD_SHARED_LIBS=ON          \
		  -D GLSLANG_TESTS=OFF             \
		  -G Ninja ..

	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR
	/sbin/ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	CC="gcc -mx32" CXX="g++ -mx32"         \
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig  \
	cmake -D CMAKE_INSTALL_PREFIX=/usr     \
		  -D CMAKE_INSTALL_LIBDIR=libx32   \
		  -D CMAKE_BUILD_TYPE=Release      \
		  -D ALLOW_EXTERNAL_SPIRV_TOOLS=ON \
		  -D BUILD_SHARED_LIBS=ON          \
		  -D GLSLANG_TESTS=OFF             \
		  -G Ninja ..
	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR
	/sbin/ldconfig
fi

update_version_list $PKG_GLSLANG
