DESCRIPTION="The Glibc package contains the main C library."

EXT_VERSION=$(basename $PKG_GLIBC tar.xz | cut -d "-" -f 2) 

case $(uname -m) in
    i?86)   ln -sfv ld-linux.so.2 $LFS/lib/ld-lsb.so.3
    ;;
    x86_64) ln -sfv ../lib/ld-linux-x86-64.so.2 $LFS/lib64
            ln -sfv ../lib/ld-linux-x86-64.so.2 $LFS/lib64/ld-lsb-x86-64.so.3
    ;;
esac

[[ -f ../$(basename $PATCH_GLIBC) ]] && patch -Np1 -i ../$(basename $PATCH_GLIBC)

mkdir -v build
cd       build

echo "rootsbindir=/usr/sbin" > configparms

../configure 								\
		--prefix=/usr  						\
		--build=$(../scripts/config.guess)	\
		--disable-nscd 						\
		--disable-werror 					\
		libc_cv_slibdir=/usr/lib			\
		--enable-kernel=5.4					\
		--enable-year2038
	  
		# --enable-year2038		  need glibc >= 2.32 and set to match, kernel >= 5.1
make

# As root:
make DESTDIR=/ install

sed '/RTLDLIST=/s@/usr@@g' -i /usr/bin/ldd

if $MULTILIB
then
	rm -rf ./*
	find .. -name "*.a" -delete
	CC="gcc -m32" CXX="g++ -m32" 					\
	../configure --prefix=/usr						\
				--host=i686-pc-linux-gnu			\
				--build=$(../scripts/config.guess)	\
				--libdir=/usr/lib32					\
				--libexecdir=/usr/lib32				\
				--disable-werror					\
				--disable-nscd 						\
				libc_cv_slibdir=/usr/lib32			\
				--enable-stack-protector=strong		\
				--enable-kernel=5.4
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -a DESTDIR/usr/lib32/* /usr/lib32/
	install -vm644 DESTDIR/usr/include/gnu/{lib-names,stubs}-32.h \
               /usr/include/gnu/
	[[ ! $(cat /etc/ld.so.conf.d/zz_i386-biarch-compat.conf | grep /usr/lib32) ]] && \
				echo "/usr/lib32" >> /etc/ld.so.conf.d/zz_i386-biarch-compat.conf
fi
if $MULTILIB_X32
then
	rm -rf ./*
	find .. -name "*.a" -delete
	CC="gcc -mx32" CXX="g++ -mx32"         			\
	../configure --prefix=/usr						\
				--host=x86_64-pc-linux-gnux32		\
				--build=$(../scripts/config.guess)	\
				--libdir=/usr/libx32				\
				--libexecdir=/usr/libx32			\
				--disable-werror					\
				--disable-nscd 						\
				libc_cv_slibdir=/usr/libx32			\
				--enable-stack-protector=strong		\
				--enable-kernel=5.4
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -a DESTDIR/usr/libx32/* /usr/libx32/
	install -vm644 DESTDIR/usr/include/gnu/{lib-names,stubs}-x32.h \
               /usr/include/gnu/
	[[ ! $(cat /etc/ld.so.conf.d/zz_x32-biarch-compat.conf | grep /usr/libx32) ]] && \
				echo "/usr/libx32" >> /etc/ld.so.conf.d/zz_x32-biarch-compat.conf
fi

update_version_list $PKG_GLIBC
