DESCRIPTION="The GLib package contains low-level libraries useful for providing data structure handling for C, portability wrappers and interfaces for such runtime functionality as an event loop, threads, dynamic loading and an object system."
# GLib

# The GLib package contains low-level libraries useful for providing data structure handling for C, portability wrappers and interfaces for such 
#runtime functionality as an event loop, threads, dynamic loading and an object system.

# Contents
# Installed Programs: gapplication, gdbus, gdbus-codegen, gio, gio-querymodules, glib-compile-resources, glib-compile-schemas, glib-genmarshal, 
#						glib-gettextize, glib-mkenums, gobject-query, gresource, gsettings, gtester, and gtester-report
# Installed Libraries: libgio-2.0.so, libglib-2.0.so, libgmodule-2.0.so, libgobject-2.0.so, and libgthread-2.0.so
# Installed Directories: /usr/include/gio-unix-2.0, /usr/include/glib-2.0, /usr/lib/glib-2.0, /usr/share/glib-2.0, /usr/share/doc/glib-2.72.3, 
#						and /usr/share/gtk-doc/html/{gio,glib,gobject} (optional)


# Short Descriptions
# 
# gapplication - can be used to start applications and to send messages to already-running instances of other applications
# gdbus - is a simple tool used for working with D-Bus objects
# gdbus-codegen - is used to generate code and/or documentation for one or more D-Bus interfaces
# gio - is a utility that makes many GIO features available from the command line
# gio-querymodules - is used to create a giomodule.cache file in the listed directories. This file lists the implemented extension points for each module that has been found
# glib-compile-resources - is used to read the resource description from a file and the files that it references to create a binary resource bundle that is suitable for use with the GResource API
# glib-compile-schemas - is used to compile all the GSettings XML schema files in a directory into a binary file with the name gschemas.compiled that can be used by GSettings
# glib-genmarshal - is a C code marshaller generation utility for GLib closures
# glib-gettextize - is a variant of the gettext internationalization utility
# glib-mkenums - is a C language enum description generation utility
# gobject-query - is a small utility that draws a tree of types
# gresource - offers a simple command line interface to GResource
# gsettings - offers a simple command line interface to GSettings
# gtester - is a test running utility
# gtester-report - is a test report formatting utility
# GLib libraries - contain low-level core libraries for the GIMP Toolkit

VERSION_EXT=$(basename $PKG_GLIB .tar.xz | cut -d "-" -f 2) 
VERSION_EXT2=$(basename $PKG_GOBJECT .tar.xz | cut -d "-" -f 3) 

if [ -f ../$(basename $PATCH_GLIB) ]; then
	patch -Np1 -i ../$(basename $PATCH_GLIB)
fi

if [ -e /usr/include/glib-2.0 ]; then
    rm -rf /usr/include/glib-2.0.old
    mv -vf /usr/include/glib-2.0{,.old}
fi

mkdir build
cd    build

meson setup ..                  \
	  --prefix=/usr             \
	  --buildtype=release       \
	  -D introspection=disabled \
	  -D glib_debug=disabled    \
	  -D man-pages=disabled     \
      -D tests=false            \
	  -D sysprof=disabled
ninja

# As root:
ninja install

if [ -f ../../$(basename $PKG_GOBJECT) ]; then
	tar xf ../../$(basename $PKG_GOBJECT)

	meson setup $(basename $PKG_GOBJECT .tar.xz) gi-build \
				--prefix=/usr --buildtype=release 
	ninja -C gi-build

	ninja -C gi-build install

	meson configure -D introspection=enabled
	ninja
fi

# if [[ $(command -v gi-docgen) != "" ]]; then
	# sed "/docs_dir =/s|$| / 'glib-' + meson.project_version()|" \
		# -i ../docs/reference/meson.build
	# meson configure -D documentation=true 
	# ninja
# fi
#ERROR: Program 'rst2html5 rst2html5.py' not found or not executable

ninja install

if $MULTILIB
then
	rm -rf *
	meson setup ..                  \
		  --cross-file=lib32        \
		  --prefix=/usr             \
		  --libdir=/usr/lib32       \
		  --buildtype=release       \
		  -D introspection=disabled \
		  -D glib_debug=disabled    \
		  -D man-pages=disabled     \
		  -D tests=false            \
		  -D sysprof=disabled       &&

	ninja
	
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	meson setup ..                  \
		  --cross-file=libx32       \
		  --prefix=/usr             \
		  --libdir=/usr/libx32      \
		  --buildtype=release       \
		  -D introspection=disabled \
		  -D glib_debug=disabled    \
		  -D man-pages=disabled     \
		  -D tests=false            \
		  -D sysprof=disabled       &&

	ninja
	
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_GOBJECT
update_version_list $PKG_GLIB
