DESCRIPTION="Git is a free and open source, distributed version control system"
# Git
# Git is a free and open source, distributed version control system designed to handle everything from small to very large projects with speed and efficiency. Every Git clone is a full-fledged repository with complete history and full revision tracking capabilities, not dependent on network access or a central server. Branching and merging are fast and easy to do. Git is used for version control of files, much like tools such as Mercurial-6.9.2, Bazaar, Subversion-1.14.5, CVS, Perforce, and Team Foundation Server.

# Contents
# Installed Programs: git, git-receive-pack, git-upload-archive, and git-upload-pack (hardlinked to each other), git-cvsserver, git-shell, gitk, and scalar
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/libexec/git-core, /usr/lib/perl5/5.40/site_perl/Git, and /usr/share/{doc/git-$EXT_VERSION,git-core,git-gui,gitk,gitweb}

# Short Descriptions
# git - is the stupid content tracker
# git-cvsserver - is a CVS server emulator for Git
# gitk - is a graphical Git repository browser (needs Tk-8.6.16)
# git-receive-pack - is invoked by git send-pack and updates the repository with the information fed from the remote end
# git-shell - is a login shell for SSH accounts to provide restricted Git access
# git-upload-archive - is invoked by git archive --remote and sends a generated archive to the other end over the git protocol
# git-upload-pack - is invoked by git fetch-pack, it discovers what objects the other side is missing, and sends them after packing
# scalar - is a repository management tool that optimizes Git for use in large repositories

# Required
# None

# Recommended
# cURL-8.12.1 (needed to use Git over http, https, ftp or ftps)

# Optional
# Apache-2.4.63 (for some tests), Fcron-3.2.1 (runtime, for scheduling git maintenance jobs), GnuPG-2.4.7 (runtime, may be used to sign Git commits or tags, or verify the signatures of them), OpenSSH-9.9p2 (runtime, needed to use Git over ssh), pcre2-10.45, Subversion-1.14.5 with Perl bindings (runtime, for git svn), Tk-8.6.16 (gitk, a simple Git repository viewer, uses Tk at runtime), Valgrind-3.24.0, Authen::SASL (runtime, for git send-email), IO-Socket-SSL-2.089 (runtime, for git send-email to connect to a SMTP server with SSL encryption), and Systemd-257.3 (runtime, rebuilt with Linux-PAM-1.7.0, for scheduling git maintenance jobs)

EXT_VERSION=$(basename $PKG_GIT .tar.xz | cut -d "-" -f 2)

./configure --prefix=/usr \
            --with-gitconfig=/etc/gitconfig \
            --with-python=python3 &&
make

#make html

#make man

# As root:
make perllibdir=/usr/lib/perl5/5.40/site_perl install

#make install-man

#make htmldir=/usr/share/doc/git-2.48.1 install-html

tar -xf ../$(basename $MAN_GIT) \
    -C /usr/share/man --no-same-owner --no-overwrite-dir

mkdir -vp   /usr/share/doc/git-$EXT_VERSION &&
tar   -xf   ../$(basename $DOCS_GIT) \
      -C    /usr/share/doc/git-$EXT_VERSION --no-same-owner --no-overwrite-dir &&

find        /usr/share/doc/git-$EXT_VERSION -type d -exec chmod 755 {} \; &&
find        /usr/share/doc/git-$EXT_VERSION -type f -exec chmod 644 {} \;

mkdir -vp /usr/share/doc/git-$EXT_VERSION/man-pages/{html,text}         &&
mv        /usr/share/doc/git-$EXT_VERSION/{git*.txt,man-pages/text}     &&
mv        /usr/share/doc/git-$EXT_VERSION/{git*.,index.,man-pages/}html &&

mkdir -vp /usr/share/doc/git-$EXT_VERSION/technical/{html,text}         &&
mv        /usr/share/doc/git-$EXT_VERSION/technical/{*.txt,text}        &&
mv        /usr/share/doc/git-$EXT_VERSION/technical/{*.,}html           &&

mkdir -vp /usr/share/doc/git-$EXT_VERSION/howto/{html,text}             &&
mv        /usr/share/doc/git-$EXT_VERSION/howto/{*.txt,text}            &&
mv        /usr/share/doc/git-$EXT_VERSION/howto/{*.,}html               &&

sed -i '/^<a href=/s|howto/|&html/|' /usr/share/doc/git-$EXT_VERSION/howto-index.html &&
sed -i '/^\* link:/s|howto/|&html/|' /usr/share/doc/git-$EXT_VERSION/howto-index.txt

update_version_list $PKG_GIT
