DESCRIPTION="Ghostscript is a versatile processor for PostScript data with the ability to render PostScript to different targets."

EXT_VERSION=$(basename $PKG_GHOSTSCRIPT .tar.xz | cut -d "-" -f 2) 

rm -rf freetype lcms2mt jpeg libpng openjpeg

GCC15=false
[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] && GCC15=true

if [[ $GCC15 ]] && [ -f ../$(basename $PATCH_GHOSTSCRIPT) ]; then
	patch -Np1 -i ../$(basename $PATCH_GHOSTSCRIPT)
fi

rm -rf zlib &&

./configure --prefix=/usr           \
            --disable-compile-inits \
            --with-system-libtiff
make
make so

# As root:
make install

make soinstall                                     &&
install -v -m644 base/*.h /usr/include/ghostscript &&
ln -sfvn ghostscript /usr/include/ps

mv -v /usr/share/doc/ghostscript/$EXT_VERSION /usr/share/doc/ghostscript-$EXT_VERSION &&
rmdir /usr/share/doc/ghostscript                                            &&
cp -r examples/ -T /usr/share/ghostscript/$EXT_VERSION/examples

tar -xvf ../$(basename $PKG_GHOSTSCRIPT_FONTS_STD) -C /usr/share/ghostscript --no-same-owner &&
tar -xvf ../$(basename $PKG_GHOSTSCRIPT_FONTS_OTHER) -C /usr/share/ghostscript --no-same-owner &&
fc-cache -v /usr/share/ghostscript/fonts/

#gs -q -dBATCH /usr/share/ghostscript/$EXT_VERSION/examples/tiger.eps

update_version_list $PKG_GHOSTSCRIPT
