DESCRIPTION="Ghostscript is a versatile processor for PostScript data with the ability to render PostScript to different targets."
# ghostscript
# Ghostscript is a versatile processor for PostScript data with the ability to render PostScript to different targets. It is a mandatory part of the cups printing stack. 

# Contents
# Installed Programs: dvipdf, eps2eps, gs, gsbj, gsc (from soinstall), gsdj, gsdj500, gslj, gslp, gsnd, gsx (from soinstall), lprsetup.sh, pdf2dsc, pdf2ps, pf2afm, pfbtopfa, pphs, printafm, ps2ascii, ps2epsi, ps2pdf, ps2pdf12, ps2pdf13, ps2pdf14, ps2pdfwr, ps2ps, ps2ps2, and unix-lpr.sh
# Installed Libraries: libgs.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/ghostscript, /usr/share/ghostscript, and /usr/share/doc/ghostscript-$EXT_VERSION

# Short Descriptions
# gs - is an interpreter for Adobe Systems' PostScript(tm) and Portable Document Format (PDF)
# libgs.so - provides Ghostscript functionality to other programs, such as GSView, ImageMagick, and libspectre

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_GHOSTSCRIPT .tar.xz | cut -d "-" -f 2) 

rm -rf freetype lcms2mt jpeg libpng openjpeg

GCC15=false
[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] && GCC15=true

if [[ $GCC15 ]] && [ -f ../$(basename $PATCH_GHOSTSCRIPT) ]; then
	patch -Np1 -i ../$(basename $PATCH_GHOSTSCRIPT)
fi

rm -rf zlib &&

./configure --prefix=/usr           \
            --disable-compile-inits \
            --with-system-libtiff
make
make so

# As root:
make install

make soinstall                                     &&
install -v -m644 base/*.h /usr/include/ghostscript &&
ln -sfvn ghostscript /usr/include/ps

mv -v /usr/share/doc/ghostscript/$EXT_VERSION /usr/share/doc/ghostscript-$EXT_VERSION &&
rmdir /usr/share/doc/ghostscript                                            &&
cp -r examples/ -T /usr/share/ghostscript/$EXT_VERSION/examples

tar -xvf ../$(basename $PKG_GHOSTSCRIPT_FONTS_STD) -C /usr/share/ghostscript --no-same-owner &&
tar -xvf ../$(basename $PKG_GHOSTSCRIPT_FONTS_OTHER) -C /usr/share/ghostscript --no-same-owner &&
fc-cache -v /usr/share/ghostscript/fonts/

#gs -q -dBATCH /usr/share/ghostscript/$EXT_VERSION/examples/tiger.eps

update_version_list $PKG_GHOSTSCRIPT
