DESCRIPTION="The Gdk Pixbuf package is a toolkit for image loading and pixel buffer manipulation."
# gdk-pixbuf
# The Gdk Pixbuf package is a toolkit for image loading and pixel buffer manipulation. It is used by GTK+ 3 to load and manipulate images. In the past it was distributed as part of GTK+ 2, but it was split off into a separate package in preparation for the change to GTK+ 3. 

# Contents
# Installed Programs: gdk-pixbuf-csource, gdk-pixbuf-pixdata, gdk-pixbuf-query-loaders, and gdk-pixbuf-thumbnailer
# Installed Libraries: libgdk_pixbuf-2.0.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/{include,lib}/gdk-pixbuf-2.0, /usr/libexec/installed-tests/gdk-pixbuf, /usr/share/installed-tests/gdk-pixbuf, /usr/share/gtk-doc/html/gdk-pixbuf, and /usr/share/thumbnailers

# Short Descriptions
# gdk-pixbuf-csource - is a small utility that generates C code containing images, used for compiling images directly into programs
# gdk-pixbuf-pixdata - is a tool used to convert GdkPixbuf to GdkPixdata
# gdk-pixbuf-query-loaders - collects information about loadable modules for Gdk Pixbuf and writes it to the default cache file location, or to stdout
# gdk-pixbuf-thumbnailer - creates thumbnails of pictures for use in other applications
# libgdk_pixbuf-2.0.so - contains functions used to load and render images

# Required
# GLib-2.82.5 (GObject Introspection required for GNOME), libjpeg-turbo-3.0.1, libpng-1.6.46, and shared-mime-info-2.4

# Recommended
# docutils-0.21.2, librsvg-2.59.2 (runtime dependency, needed for loading symbolic icons) and libtiff-4.7.0

# Recommended_Runtime
# None

# Optional
# Gi-DocGen-2025.3 (to generate documentation), libavif-1.2.0 (runtime dependency, needed for loading AVIF images), libjxl-0.11.1 (runtime dependency, needed for loading JPEG XL images), and webp-pixbuf-loader-0.2.7 (runtime dependency, needed for loading WebP images)

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_GDK_PIXBUF .tar.xz | cut -d "-" -f 3) 

mkdir build &&
cd    build &&

meson setup ..            \
      --prefix=/usr       \
      --buildtype=release \
      -D others=enabled   \
      --wrap-mode=nofallback &&
ninja

sed "/docs_dir =/s@\$@ / 'gdk-pixbuf-${EXT_VERSION}'@" -i ../docs/meson.build &&
meson configure -D gtk_doc=true                                        &&
ninja

# As root:
ninja install

update_version_list $PKG_GDK_PIXBUF
