DESCRIPTION="GDB, the GNU Project debugger."
# GDB
# GDB, the GNU Project debugger, allows you to see what is going on “inside” another program while it executes -- or what another program was doing at the moment it crashed. Note that GDB is most effective when tracing programs and libraries that were built with debugging symbols and not stripped. 

# Contents
# Installed Programs: gcore, gdb, gdbserver, gdb-add-index, and gstack
# Installed Libraries: libinproctrace.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/{include,share}/gdb and /usr/share/doc/gdb-16.2

# Short Descriptions
# gcore - generates a core dump of a running program
# gdb - is the GNU Debugger
# gdbserver - is a remote server for the GNU debugger (it allows programs to be debugged from a different machine)
# gdb-add-index - Allows adding index files to ELF binaries. This speeds up gdb start on large programs.
# gstack - prints a stack trace from a program which is currently running
# libinproctrace.so - contains functions for the in-process tracing agent. The agent allows for installing fast tracepoints, listing static tracepoint markers, probing static tracepoints markers, and starting trace monitoring.

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_GDB .tar.xz | cut -d "-" -f 2) 

mkdir build
cd    build

../configure --prefix=/usr          \
             --with-system-readline \
             --with-python=/usr/bin/python3
make

[[ $(command -v doxygen) != "" ]] && MAKE_DOC=true && make -C gdb/doc doxy

# pushd gdb/testsuite &&
# make  site.exp      &&
# echo  "set gdb_test_timeout 30" >> site.exp &&
# make check 2>1 | tee gdb-check.log
# popd

# As root:
make -C gdb install
make -C gdbserver install

if [[ $MAKE_DOC == "true" ]]; then
	install -d /usr/share/doc/gdb-$EXT_VERSION
	rm -rf gdb/doc/doxy/xml
	cp -Rv gdb/doc/doxy /usr/share/doc/gdb-$EXT_VERSION
fi

update_version_list $PKG_GDB
