DESCRIPTION="The GCC package contains the GNU Compiler Collection."

EXT_VERSION=$(basename $PKG_GCC .tar.xz | cut -d "-" -f 2) 

unset C_INCLUDE_PATH
unset CPLUS_INCLUDE_PATH

ENABLE_LANGUAGES="c,c++"
[[ $GCC_FORTRAN == true ]] && ENABLE_LANGUAGES="$ENABLE_LANGUAGES,fortran"
[[ $GCC_GO == true ]] && ENABLE_LANGUAGES="$ENABLE_LANGUAGES,go"
[[ $GCC_M2 == true ]] && ENABLE_LANGUAGES="$ENABLE_LANGUAGES,m2"
[[ $GCC_COBOL == true ]] && ENABLE_LANGUAGES="$ENABLE_LANGUAGES,cobol"
[[ $GCC_OBJC == true ]] && ENABLE_LANGUAGES="$ENABLE_LANGUAGES,objc,obj-c++"

if [[ $MULTILIB == "true" ]]; then
	case $(uname -m) in
	  x86_64)
		sed -e '/m64=/s/lib64/lib/' \
			-e '/m32=/s/m32=.*/m32=..\/lib32$(call if_multiarch,:i386-linux-gnu)/' \
			-i.orig gcc/config/i386/t-linux64
	  ;;
	esac

	sed '/STACK_REALIGN_DEFAULT/s/0/(!TARGET_64BIT \&\& TARGET_SSE)/' \
		  -i gcc/config/i386/i386.h
	
	mlist="m64,m32"
	[[ $MULTILIB_X32 ]] && mlist="$mlist,mx32"
	
	OPTIONS="--enable-multilib	--with-multilib-list=$mlist LD=ld"
	
	ulimit -s -H unlimited
else
	case $(uname -m) in
	  x86_64)
		sed -i.orig '/m64=/s/lib64/lib/' gcc/config/i386/t-linux64
	  ;;
	esac
	
	OPTIONS="--disable-multilib"
fi

mkdir build
cd    build

# change pc to $NAME
../configure --prefix=/usr	\
	LD=ld                   \
	$OPTIONS 				\
    --with-system-zlib		\
    --enable-default-pie	\
    --enable-default-ssp	\
    --enable-host-pie		\
	--disable-bootstrap     \
    --disable-fixincludes	\
	--enable-libssp			\
	--enable-year2038		\
	--with-system-zlib		\
    --enable-languages=$ENABLE_LANGUAGES
    # --enable-languages=c,c++,fortran,go,m2,cobol,objc,obj-c++
	# Apple: objc,obj-c++
	# GNAT is required to build ada
	# GDC is required to build d
	# libphobos required by d
	# --enable-year2038		  need glibc >= 2.32 and set to match, kernel >= 5.1

make

# As root:
make install

mkdir -pv /usr/share/gdb/auto-load/usr/lib
mv -v /usr/lib/*gdb.py /usr/share/gdb/auto-load/usr/lib

chown -v -R root:root \
    /usr/lib/gcc/*linux-gnu/${EXT_VERSION}/include{,-fixed}

#[ -h /usr/lib/cpp ] && unlink /usr/lib/cpp
ln -sfvr /usr/bin/cpp /usr/lib

#[ -h /usr/share/man/man1/cc.1 ] && unlink /usr/share/man/man1/cc.1
ln -sfv gcc.1 /usr/share/man/man1/cc.1

#[ -h /usr/lib/bfd-plugins/liblto_plugin.so ] && unlink /usr/lib/bfd-plugins/liblto_plugin.so

ln -sfv ../../libexec/gcc/$(gcc -dumpmachine)/${EXT_VERSION}/liblto_plugin.so \
        /usr/lib/bfd-plugins/

update_version_list $PKG_GCC
