DESCRIPTION="The GCC package contains the GNU Compiler Collection."

EXT_VERSION=$(basename $PKG_GCC .tar.xz | cut -d "-" -f 2) 

unset C_INCLUDE_PATH
unset CPLUS_INCLUDE_PATH

if [[ $MULTILIB == "true" ]]; then
	case $(uname -m) in
	  x86_64)
		sed -e '/m64=/s/lib64/lib/' \
			-e '/m32=/s/m32=.*/m32=..\/lib32$(call if_multiarch,:i386-linux-gnu)/' \
			-i.orig gcc/config/i386/t-linux64
	  ;;
	esac

	sed '/STACK_REALIGN_DEFAULT/s/0/(!TARGET_64BIT \&\& TARGET_SSE)/' \
		  -i gcc/config/i386/i386.h
	
	mlist=m64,m32,mx32
	OPTIONS="--enable-multilib	--with-multilib-list=$mlist"
else
	case $(uname -m) in
	  x86_64)
		sed -i.orig '/m64=/s/lib64/lib/' gcc/config/i386/t-linux64
	  ;;
	esac
	
	OPTIONS="--disable-multilib"
fi

mkdir build
cd    build

../configure --prefix=/usr	\
	$OPTIONS \
    --with-system-zlib		\
    --enable-default-pie	\
    --enable-default-ssp	\
    --enable-host-pie		\
    --disable-fixincludes	\
	--enable-year2038		\
	--enable-libssp			\
	--enable-libgm2			\
    --enable-languages=c,c++,go,objc,obj-c++,m2 #,fortran #,m2 #,ada
	# --enable-libada         build libada directory
	# --enable-libgm2         build libgm2 directory Modula-2 (m2)
	# --enable-libssp         build libssp directory Stack Smashing Protection
	# GNAT is required to build ada

make

# As root:
make install

mkdir -pv /usr/share/gdb/auto-load/usr/lib
mv -v /usr/lib/*gdb.py /usr/share/gdb/auto-load/usr/lib

chown -v -R root:root \
    /usr/lib/gcc/*linux-gnu/${EXT_VERSION}/include{,-fixed}

[[ -h /usr/lib/bfd-plugins/liblto_plugin.so ]] && unlink /usr/lib/bfd-plugins/liblto_plugin.so

ln -sfv ../../libexec/gcc/$(gcc -dumpmachine)/${EXT_VERSION}/liblto_plugin.so \
        /usr/lib/bfd-plugins/

update_version_list $PKG_GCC
