DESCRIPTION="Frei0r is a minimalistic plugin API for video effects."

[[ $(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1) == 4 ]] && OPTIONS="-D CMAKE_POLICY_VERSION_MINIMUM=3.5" || OPTIONS=""

EXT_VERSION=$(basename $PKG_FREI0R_PLUGINS .tar.gz | cut -d "-" -f 2) 

mkdir -vp build &&
cd        build &&

[[ $(command -v opencv_version) == "" ]] && OPTIONS="$OPTIONS -D WITHOUT_OPENCV=TRUE" || OPTIONS="$OPTIONS -D WITHOUT_OPENCV=FALSE"
[ ! -f /lib/libgavl.so ] && OPTIONS="$OPTIONS -D WITHOUT_GAVL=TRUE" || OPTIONS="$OPTIONS -D WITHOUT_GAVL=FALSE"

cmake -D CMAKE_INSTALL_PREFIX=/usr \
      -D CMAKE_BUILD_TYPE=Release  \
	  $OPTIONS		\
      -W no-dev ..   

make

# As root:
make install

update_version_list $PKG_FREI0R_PLUGINS
