DESCRIPTION="The FreeType2 package contains a library which allows applications to properly render TrueType fonts."
# FreeType2

# The FreeType2 package contains a library which allows applications to properly render TrueType fonts.

# Contents
# Installed Programs: freetype-config
# Installed Libraries: libfreetype.so
# Installed Directories: /usr/include/freetype2 and /usr/share/doc/freetype-2.13.3

# Short Descriptions
# freetype-config - is used to get FreeType compilation and linking information
# libfreetype.so - contains functions for rendering various font types, such as TrueType and Type1

VERSION_EXT=$(basename $PKG_FREETYPE .tar.xz | cut -d "-" -f 2) 

# Stage 1, build without harfbuzz
if [[ $(command -v hb-info) == "" ]]; then
	sed -ri "s:.*(AUX_MODULES.*valid):\1:" modules.cfg

	sed -r "s:.*(#.*SUBPIXEL_RENDERING) .*:\1:" \
		-i include/freetype/config/ftoption.h

	./configure --prefix=/usr --enable-freetype-config --disable-static --without-harfbuzz
	make

	# As root:
	make install

	if $MULTILIB
	then
		make distclean 
		CC="gcc -m32" CXX="g++ -m32" 			\
		PKG_CONFIG_PATH=/usr/lib32/pkgconfig 	\
		./configure --prefix=/usr				\
				--libdir=/usr/lib32				\
				--host=i686-pc-linux-gnu		\
				--enable-freetype-config		\
				--disable-static
		make
		make DESTDIR=$PWD/DESTDIR install
		cp -vr DESTDIR/usr/lib32/* /usr/lib32
		rm -rf DESTDIR 
		ldconfig
	fi
	if $MULTILIB_X32
	then	
		make distclean
		CC="gcc -mx32" CXX="g++ -mx32"         		\
		PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
		./configure --prefix=/usr					\
				--libdir=/usr/libx32				\
				--host=x86_64-pc-linux-gnux32		\
				--enable-freetype-config			\
				--disable-static
		make
		make DESTDIR=$PWD/DESTDIR install
		cp -vr DESTDIR/usr/libx32/* /usr/libx32
		rm -rf DESTDIR 
		ldconfig	
	fi

	echo "Installing harfbuzz"
	extension --install harfbuzz
	echo "Finished harfbuzz"
fi

# Step 3 rebuild graphite2
if [[ $(freetype-config --cflags | grep harfbuzz) == "" ]] || [[ $BUILD_ALL == "true" ]]; then
	make distclean
	
	tar -xf ../$(basename $DOC_FREETYPE) --strip-components=2 -C docs

	# sed -ri "s:.*(AUX_MODULES.*valid):\1:" modules.cfg

	# sed -r "s:.*(#.*SUBPIXEL_RENDERING) .*:\1:" \
		# -i include/freetype/config/ftoption.h

	./configure --prefix=/usr --enable-freetype-config --disable-static
	make

	# As root:
	make install

	cp -v -R docs -T /usr/share/doc/freetype-$VERSION_EXT
	rm -v /usr/share/doc/freetype-$VERSION_EXT/freetype-config.1

	if $MULTILIB
	then
		make distclean 
		CC="gcc -m32" CXX="g++ -m32" 			\
		PKG_CONFIG_PATH=/usr/lib32/pkgconfig 	\
		./configure --prefix=/usr				\
				--libdir=/usr/lib32				\
				--host=i686-pc-linux-gnu		\
				--enable-freetype-config		\
				--disable-static
		make
		make DESTDIR=$PWD/DESTDIR install
		cp -vr DESTDIR/usr/lib32/* /usr/lib32
		rm -rf DESTDIR 
		ldconfig
	fi
	if $MULTILIB_X32
	then	
		make distclean
		CC="gcc -mx32" CXX="g++ -mx32"         		\
		PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
		./configure --prefix=/usr					\
				--libdir=/usr/libx32				\
				--host=x86_64-pc-linux-gnux32		\
				--enable-freetype-config			\
				--disable-static
		make
		make DESTDIR=$PWD/DESTDIR install
		cp -vr DESTDIR/usr/libx32/* /usr/libx32
		rm -rf DESTDIR 
		ldconfig	
	fi
	
	update_version_list $PKG_FREETYPE
fi
