DESCRIPTION="The FOP (Formatting Objects Processor) package contains a print formatter driven by XSL formatting objects (XSL-FO)."

EXT_VERSION=$(basename $PKG_FOP .tar.gz | cut -d "-" -f 2) 

source /etc/profile

if [[ $(ping -c 1 8.8.8.8 | grep "Destination Net Unreachable") != "" ]]; then
	pushd ~
	curl -LO https://repo.dillonsociety.com/pub/DSLsq/portholes/.m2.tar.gz
	tar -xvf .m2.tar.gz
	rm .m2.tar.gz
	popd
fi

unzip ../$(basename $PKG_OFFO)
cp offo-hyphenation/hyph/* fop/hyph
rm -rf offo-hyphenation

tar -xf ../$(basename $PKG_MAVEN) -C /tmp

[ -f ../$(basename $PATCH_FOP) ] && patch -Np1 -i ../$(basename $PATCH_FOP)

sed -i '\@</javad@i\
<arg value="-Xdoclint:none"/>\
<arg value="--allow-script-in-comments"/>\
<arg value="--ignore-source-errors"/>' \
    fop/build.xml

cd fop

LC_ALL=C.UTF-8                     \
PATH=$PATH:/tmp/$(basename $PKG_MAVEN -bin.tar.gz)/bin \
ant package javadocs

mv build/javadocs .

# As root:
install -v -d -m755 -o root -g root          /opt/fop-$EXT_VERSION
cp -vR build conf examples fop* javadocs lib /opt/fop-$EXT_VERSION
chmod a+x /opt/fop-${EXT_VERSION}/fop
ln -v -sfn fop-${EXT_VERSION} /opt/fop

rm -rf /tmp/$(basename $PKG_MAVEN -bin.tar.gz)

cat > ~/.foprc << "EOF"
FOP_OPTS="-Xmx<RAM_Installed>m"
FOP_HOME="/opt/fop"
EOF

cat > /etc/profile.d/fop.sh << "EOF"
# Begin /etc/profile.d/fop.sh

pathappend /opt/fop

# End /etc/profile.d/fop.sh
EOF

update_version_list $PKG_FOP
