DESCRIPTION="The Fontconfig package contains a library and support programs used for configuring and customizing font access."
# Fontconfig

# The Fontconfig package contains a library and support programs used for configuring and customizing font access.

# Contents
# Installed Programs: fc-cache, fc-cat, fc-conflist, fc-list, fc-match, fc-pattern, fc-query, fc-scan, and fc-validate
# Installed Libraries: libfontconfig.so
# Installed Directories: /etc/fonts, /usr/include/fontconfig, /usr/share/doc/fontconfig-2.16.0, /usr/share/fontconfig, /usr/share/xml/fontconfig, and /var/cache/fontconfig

# Short Descriptions
# fc-cache - is used to create font information caches
# fc-cat - is used to read font information caches
# fc-conflist - shows the ruleset files' information on the system
# fc-list - is used to create font lists
# fc-match - is used to match available fonts, or find fonts that match a given pattern
# fc-pattern - is used to parse pattern (empty pattern by default) and show the parsed result
# fc-query - is used to query fonts files and print resulting patterns
# fc-scan - is used to scan font files and directories, and print resulting patterns
# fc-validate - is used to validate font files
# libfontconfig.so - contains functions used by the Fontconfig programs and also by other programs to configure or customize font access

VERSION_EXT=$(basename $PKG_FONTCONFIG .tar.xz | cut -d "-" -f 2) 

# mkdir build &&
# cd    build &&

./configure --prefix=/usr        \
            --sysconfdir=/etc    \
            --localstatedir=/var \
            --disable-docs       \
            --docdir=/usr/share/doc/fontconfig-$VERSION_EXT &&
make

# As root:
make install

install -v -dm755 \
        /usr/share/{man/man{1,3,5},doc/fontconfig-$VERSION_EXT} &&
install -v -m644 fc-*/*.1         /usr/share/man/man1 &&
install -v -m644 doc/*.3          /usr/share/man/man3 &&
install -v -m644 doc/fonts-conf.5 /usr/share/man/man5 &&
install -v -m644 doc/*.{pdf,sgml,txt,html} \
                                  /usr/share/doc/fontconfig-$VERSION_EXT

if $MULTILIB
then
	make clean
	CC="gcc -m32" CXX="g++ -m32"			\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --prefix=/usr				\
				--sysconfdir=/etc			\
				--localstatedir=/var		\
				--libdir=/usr/lib32			\
				--host=i686-pc-linux-gnu	\
				--disable-docs  

	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR
	ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	./configure --prefix=/usr        \
				--sysconfdir=/etc    \
				--localstatedir=/var \
				--disable-docs       \
				--docdir=/usr/share/doc/fontconfig-$VERSION_EXT

	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR
	ldconfig	
fi

update_version_list $PKG_FONTCONFIG
