DESCRIPTION="FLAC is an audio CODEC similar to MP3, but lossless, meaning that audio is compressed without losing any information."
# FLAC
# FLAC is an audio CODEC similar to MP3, but lossless, meaning that audio is compressed without losing any information. 

# Contents
# Installed Programs: flac and metaflac
# Installed Libraries: libFLAC.so and libFLAC++.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/FLAC, /usr/include/FLAC++ and /usr/share/doc/flac-1.5.0

# Short Descriptions
# flac - is a command-line utility for encoding, decoding and converting FLAC files
# metaflac - is a program for listing, adding, removing, or editing metadata in one or more FLAC files
# libFLAC{,++}.so - these libraries provide native FLAC and Ogg FLAC C/C++ APIs for programs utilizing FLAC

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# libogg-1.3.5, DocBook-utils-0.6.14, Doxygen-1.13.2, and Valgrind-3.24.0

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_FLAC .tar.xz | cut -d "-" -f 2) 

./configure --prefix=/usr                                \
            --disable-thorough-tests                     \
            --docdir=/usr/share/doc/flac-$EXT_VERSION
make

# As root:
make install

if $MULTILIB
then
	make distclean 
	CC="gcc -m32" CXX="g++ -m32"         	\
	CFLAGS=+=" -L/usr/lib32"				\
	LDFLAGS=+=" -L/usr/lib32"				\
	./configure --prefix=/usr 				\
				--libdir=/usr/lib32			\
				--host=i686-pc-linux-gnu	\
				--disable-static 
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make distclean
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	CFLAGS=+=" -L/usr/libx32"					\
	LDFLAGS=+=" -L/usr/libx32"					\
	./configure --prefix=/usr 					\
				--libdir=/usr/libx32			\
				--host=x86_64-pc-linux-gnux32	\
				--disable-static
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_FLAC
