DESCRIPTION="FFmpeg is a solution to record, convert and stream audio and video."
# blank
# The 

# Contents
# Installed Programs: None
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# None

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_FFMPEG .tar.xz | cut -d "-" -f 2) 

[ -f ../$(basename $PATCH_FFMPEG_CHROMIUM) ] && patch -Np1 -i ../$(basename $PATCH_FFMPEG_CHROMIUM)

sed -e 's/X265_BUILD >= 210/(&) \&\& (X265_BUILD < 213)/' \
    -i libavcodec/libx265.c
	
[ -f ../$(basename $PATCH_FFMPEG_TEXINFO) ] && patch -Np1 -i ../$(basename $PATCH_FFMPEG_TEXINFO)

./configure --prefix=/usr        \
            --enable-gpl         \
            --enable-version3    \
            --enable-nonfree     \
            --disable-static     \
            --enable-shared      \
            --disable-debug      \
            --enable-libaom      \
            --enable-libass      \
            --enable-libfdk-aac  \
            --enable-libfreetype \
            --enable-libmp3lame  \
            --enable-libopus     \
            --enable-libvorbis   \
            --enable-libvpx      \
            --enable-libx264     \
            --enable-libx265     \
            --enable-openssl     \
            --ignore-tests=enhanced-flv-av1 \
            --docdir=/usr/share/doc/ffmpeg-$EXT_VERSION

make

gcc tools/qt-faststart.c -o tools/qt-faststart

pushd doc &&
for DOCNAME in `basename -s .html *.html`
do
    texi2pdf -b $DOCNAME.texi
    texi2dvi -b $DOCNAME.texi

    dvips    -o $DOCNAME.ps   \
                $DOCNAME.dvi
done &&
popd &&
unset DOCNAME

doxygen doc/Doxyfile

# As root:
make install

install -v -m755    tools/qt-faststart /usr/bin
install -v -m755 -d           /usr/share/doc/ffmpeg-$EXT_VERSION
install -v -m644    doc/*.txt /usr/share/doc/ffmpeg-$EXT_VERSION

install -v -m644 doc/*.pdf /usr/share/doc/ffmpeg-$EXT_VERSION
install -v -m644 doc/*.ps  /usr/share/doc/ffmpeg-$EXT_VERSION

install -v -m755 -d /usr/share/doc/ffmpeg-${EXT_VERSION}/api
cp -vr doc/doxy/html/* /usr/share/doc/ffmpeg-${EXT_VERSION}/api
find /usr/share/doc/ffmpeg-${EXT_VERSION}/api -type f -exec chmod -c 0644 \{} \;
find /usr/share/doc/ffmpeg-${EXT_VERSION}/api -type d -exec chmod -c 0755 \{} \;

update_version_list $PKG_FFMPEG
