DESCRIPTION="The Extra Cmake Modules package contains extra CMake modules used by KDE Frameworks and other packages."

VERSION_EXT=$(basename $PKG_EXTRA_CMAKE_MODULES .tar.xz | cut -d "-" -f 2) 

source /etc/profile

[ -f ../$(basename $PATCH_EXTRA_CMAKE_MODULES) ] && patch -Np1 -i ../$(basename $PATCH_EXTRA_CMAKE_MODULES)

sed -i '/"lib64"/s/64//' kde-modules/KDEInstallDirsCommon.cmake

sed -e '/PACKAGE_INIT/i set(SAVE_PACKAGE_PREFIX_DIR "${PACKAGE_PREFIX_DIR}")' \
    -e '/^include/a set(PACKAGE_PREFIX_DIR "${SAVE_PACKAGE_PREFIX_DIR}")' \
    -i ECMConfig.cmake.in
	
mkdir build
cd    build

cmake -D CMAKE_INSTALL_PREFIX=/usr -D BUILD_WITH_QT6=ON ..
make


# As root:
make install

update_version_list $PKG_EXTRA_CMAKE_MODULES
