DESCRIPTION="The Emacs package contains an extensible, customizable, self-documenting real-time display editor."

EXT_VERSION=$(basename $PKG_EMACS .tar.xz | cut -d "-" -f 2) 

OPTIONS=""
[[ $(command -v magick) != "" ]] && OPTIONS="--with-imagemagick"
[[ $(command -v gifbuild) == "" ]] && OPTIONS="--with-gif=no"
[[ $(command -v tiffinfo) == "" ]] && OPTIONS="--with-tiff=no"
[[ $(command -v gnutls-cli) == "" ]] && OPTIONS="--with-gnutls=no"
[[ $(command -v hb-info) == "" ]] && OPTIONS="--without-harfbuzz"
[ ! -f /lib/libjansson.so ] && OPTIONS="--with-json=no"

./configure --prefix=/usr --with-imagemagick
make

# As root:
make install
chown -v -R root:root /usr/share/emacs/$EXT_VERSION

[[ $(command -v gtk-launch) != "" ]] && gtk-update-icon-cache -qtf /usr/share/icons/hicolor

update_version_list $PKG_EMACS
