DESCRIPTION="The Doxyqml package allows using Doxygen to document QML classes."
# Doxyqml Python Module
# The Doxyqml package allows using Doxygen to document QML classes.

# Contents
# Installed Programs: doxyqml
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/lib/python3.13/site-packages/doxyqml and /usr/lib/python3.13/site-packages/doxyqml-0.5.3.dist-info

# Short Descriptions
# doxyqml - is a Doxygen input filter for QML files.

# Required
# Doxygen-1.13.2

# Recommended
# None

# Optional
# pytest-8.3.5

EXT_VERSION=$(basename $PKG_DOXYQML .tar.?z*)

pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD

# As root:
pip3 install --no-index --find-links dist --no-user doxyqml

#python3 tests/functional/tests.py &&
#python3 tests/unit/tests.py

# -w dist: builds the appropriate "wheel" for this module in the directory dist.
# --no-build-isolation: tells pip3 to run the build in the system environment instead of creating a temporary build environment.
# --no-deps: prevents pip3 from building wheels for the project's dependencies.
# --no-index: ignores the package index (only looking at --find-links URLs instead).
# --find-links dist: looks for links to archives such as wheel (.whl) files in the directory dist.
# --no-cache-dir: disables the cache to prevent a warning when installing as the root user.
# --no-user: Prevent mistakenly running the install command as a non-root user.
# --upgrade: Upgrade the package to the newest available version. This option is used with the install command if a version of the package is already installed.
# --force-reinstall: Reinstall the package even if it is up-to-date. This option is used with the install command if reinstalling the package or reverting to an earlier version of the package.
# --no-deps: Do not install package dependencies. This option may be needed with the --upgrade or --force-reinstall options.

update_version_list $PKG_DOXYQML
