DESCRIPTION="The Doxygen package contains a documentation system for Cpp, C, Java, Objective-C, Corba IDL and to some extent PHP, CS and D"
# Doxygen
# The Doxygen package contains a documentation system for C++, C, Java, Objective-C, Corba IDL and to some extent PHP, C# and D. It is useful for generating HTML documentation and/or an off-line reference manual from a set of documented source files. There is also support for generating output in RTF, PostScript, hyperlinked PDF, compressed HTML, and Unix man pages. The documentation is extracted directly from the sources, which makes it much easier to keep the documentation consistent with the source code.

# Contents
# Installed Programs: doxygen and optionally, doxywizard, doxyindexer and doxysearch.cgi
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/share/doc/doxygen-1.13.2

# Short Descriptions
# doxygen - is a command-line based utility used to generate template configuration files and then generate documentation from these templates. Use doxygen --help for an explanation of the command-line parameters
# doxywizard - is a GUI front-end for configuring and running doxygen
# doxyindexer - generates a search index called doxysearch.db from one or more search data files produced by doxygen. See, e.g. https://javacc.github.io/javacc/
# doxysearch.cgi - is a CGI program to search the data indexed by doxyindexer

# Required
# CMake-3.31.6 and git-2.48.1

# Recommended
# Qt-6.8.2 (for doxywizard)

# Optional
# Graphviz-12.2.1, ghostscript-10.04.0, libxml2-2.13.6 (required for the tests), LLVM-19.1.7 (with clang), texlive-20240312 (or install-tl-unx), xapian-1.4.27 (for doxyindexer), and javacc

EXT_VERSION=$(basename $PKG_DOXYGEN .src.tar.gz | cut -d "-" -f 2)

grep -rl '^#!.*python$' | xargs sed -i '1s/python/&3/'

OPTION=""
[[ $(command -v designer) != "" ]] && OPTION="$OPTION -D build_wizard=ON -D force_qt=Qt6" || OPTION="$OPTION -D build_wizard=OFF"
[[ $(command -v clang) != "" ]] && OPTION="$OPTION -D use_libclang=ON"
[[ $(command -v xapian-check) != "" ]] && OPTION="$OPTION -D build_search=ON"

[[ $(command -v gs) != "" ]] && [[ $(command -v texdoc) != "" ]] && make_docs=true || make_docs=false

[ -d build ] && rm -r build

mkdir -v build
cd       build


cmake -G "Unix Makefiles"          \
	  -D CMAKE_BUILD_TYPE=Release  \
	  -D CMAKE_INSTALL_PREFIX=/usr \
	  $OPTION	\
	  -W no-dev ..
make

source /etc/profile
make_docs=false
if [[ $make_docs == "true" ]]; then
	make_docs=true
	cmake  -D build_doc=ON \
		   -D DOC_INSTALL_DIR=share/doc/doxygen-$EXT_VERSION \
		   ..
	make docs
fi

# As root:
make install
[[ $make_docs == "true" ]] && install -vm644 ../doc/*.1 /usr/share/man/man1

update_version_list $PKG_DOXYGEN
