DESCRIPTION="docutils is a set of Python modules and programs for processing plaintext docs into formats such as HTML, XML, or LaTeX."
# docutils Python Module
# docutils is a set of Python modules and programs for processing plaintext docs into formats such as HTML, XML, or LaTeX.

# Contents
# Installed Programs: docutils, rst2html4, rst2html5, rst2html, rst2latex, rst2man, rst2odt_prepstyles, rst2odt, rst2pseudoxml, rst2s5, rst2xetex, rst2xml, and rstpep2html
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/lib/python3.13/site-packages/docutils{,-0.21.2.dist-info}

# Short Descriptions
# docutils - converts documents into various formats
# rst2html - generates (X)HTML documents from standalone reStructuredText sources
# rst2html4 - generates (X)HTML documents from standalone reStructuredText sources
# rst2html5 - generates HTML5 documents from standalone reStructuredText sources
# rst2latex - generates LaTeX documents from standalone reStructuredText sources
# rst2man - generates plain unix manual documents from standalone reStructuredText sources
# rst2odt - generates OpenDocument/OpenOffice/ODF documents from standalone reStructuredText sources
# rst2odt_prepstyles - Fix a word-processor-generated styles.odt for odtwriter use
# rst2pseudoxml - generates pseudo-XML from standalone reStructuredText sources (for testing purposes)
# rst2s5 - generates S5 (X)HTML slideshow from standalone reStructuredText sources
# rst2xetex - generates LaTeX documents from standalone reStructuredText sources for compilation with the Unicode-aware TeX variants XeLaTeX or LuaLaTeX
# rst2xml - generates Docutils-native XML from standalone reStructuredText sources
# rstpep2html - generates (X)HTML from reStructuredText-format PEP files

# Required
# None

# Recommended
# None

# Optional
# None

#EXT_VERSION=$(basename $PKG_DOCUTILS_PY .tar.gz | cut -d "-" -f 2)

for f in /usr/bin/rst*.py; do
  rm -fv /usr/bin/$(basename $f .py)
done

pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD

# As root:
pip3 install --no-index --find-links dist --no-user docutils

# -w dist: builds the appropriate "wheel" for this module in the directory dist.
# --no-build-isolation: tells pip3 to run the build in the system environment instead of creating a temporary build environment.
# --no-deps: prevents pip3 from building wheels for the project's dependencies.
# --no-index: ignores the package index (only looking at --find-links URLs instead).
# --find-links dist: looks for links to archives such as wheel (.whl) files in the directory dist.
# --no-cache-dir: disables the cache to prevent a warning when installing as the root user.
# --no-user: Prevent mistakenly running the install command as a non-root user.
# --upgrade: Upgrade the package to the newest available version. This option is used with the install command if a version of the package is already installed.
# --force-reinstall: Reinstall the package even if it is up-to-date. This option is used with the install command if reinstalling the package or reverting to an earlier version of the package.
# --no-deps: Do not install package dependencies. This option may be needed with the --upgrade or --force-reinstall options.

update_version_list $PKG_DOCUTILS_PY
