DESCRIPTION="The DocBook XSL Stylesheets (Namespaced) package contains XSL stylesheets."

EXT_VERSION=$(basename $PKG_DOCBOOK_XSL_NS .tar.bz2 | cut -d "-" -f 3) 

[ -f ../$(basename $PATCH_DOCBOOK_XSL_NS) ] && patch -Np1 -i ../$(basename $PATCH_DOCBOOK_XSL_NS)

# As root:
install -v -m755 -d /usr/share/xml/docbook/xsl-stylesheets-$EXT_VERSION

cp -v -R VERSION assembly common eclipse epub epub3 extensions fo        \
         highlighting html htmlhelp images javahelp lib manpages params  \
         profiling roundtrip slides template tests tools webhelp website \
         xhtml xhtml-1_1 xhtml5                                          \
    /usr/share/xml/docbook/xsl-stylesheets-$EXT_VERSION

[ ! -h /usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}/VERSION.xsl ] && ln -s VERSION /usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}/VERSION.xsl

[ ! -d /etc/xml ] && install -v -m755 -d /etc/xml
[ ! -f /etc/xml/catalog ] && xmlcatalog --noout --create /etc/xml/catalog

xmlcatalog --noout --add "rewriteSystem" \
           "http://cdn.docbook.org/release/xsl/${EXT_VERSION}" \
           "/usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteSystem" \
           "https://cdn.docbook.org/release/xsl/${EXT_VERSION}" \
           "/usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteURI" \
           "http://cdn.docbook.org/release/xsl/${EXT_VERSION}" \
           "/usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteURI" \
           "https://cdn.docbook.org/release/xsl/${EXT_VERSION}" \
           "/usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteSystem" \
           "http://cdn.docbook.org/release/xsl/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteSystem" \
           "https://cdn.docbook.org/release/xsl/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteURI" \
           "http://cdn.docbook.org/release/xsl/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteURI" \
           "https://cdn.docbook.org/release/xsl/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteSystem" \
           "http://docbook.sourceforge.net/release/xsl-ns/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteURI" \
           "http://docbook.sourceforge.net/release/xsl-ns/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-${EXT_VERSION}" \
    /etc/xml/catalog

update_version_list $PKG_DOCBOOK_XSL_NS
