DESCRIPTION="Useful transformations for XML DocBook files"
# docbook-xsl-nons
# The DocBook XSL Stylesheets package contains XSL stylesheets. These are useful for performing transformations on XML DocBook files.

# Contents
# Installed Files: /usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION/*/*.xsl
# Installed Directories: /usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION and /usr/share/doc/docbook-xsl-nons-$DOCBOOK_VERSION

# Short Descriptions
# XSL Stylesheets - are used for performing transformations on XML files

# Config Files
# /etc/xml/catalog

# First, fix a problem that causes stack overflows when doing recursion:
if [[ -f ../$(basename $PATCH_DOCBOOK_XSL_NONS) ]]; then
	patch -Np1 -i ../$(basename $PATCH_DOCBOOK_XSL_NONS)
fi

# If you downloaded the optional documentation tarball, unpack it with the following command:
if [[ -f ../$(basename $MAN_DOCBOOK_XSL_DOC) ]]; then
	tar -xf ../$(basename $MAN_DOCBOOK_XSL_DOC) --strip-components=1
fi

DOCBOOK_VERSION=$((basename $PKG_DOCBOOK_XSL_NONS .tar.bz2) | cut -d "-" -f 4)

# As root:
install -v -m755 -d /usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION &&

cp -v -R VERSION assembly common eclipse epub epub3 extensions fo        \
         highlighting html htmlhelp images javahelp lib manpages params  \
         profiling roundtrip slides template tests tools webhelp website \
         xhtml xhtml-1_1 xhtml5                                          \
    /usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION &&

ln -s VERSION /usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION/VERSION.xsl &&

install -v -m644 -D README \
                    /usr/share/doc/docbook-xsl-nons-$DOCBOOK_VERSION/README.txt &&
install -v -m644    RELEASE-NOTES* NEWS* \
                    /usr/share/doc/docbook-xsl-nons-$DOCBOOK_VERSION

# If you downloaded the optional documentation tarball, install the documentation by issuing the following command as the root user:
if [[ -f ../$(basename $MAN_DOCBOOK_XSL_DOC) ]]; then
	cp -v -R doc/* /usr/share/doc/docbook-xsl-nons-$DOCBOOK_VERSION
fi

#If you are installing the current version of docbook-xsl-nons over a previous version of docbook-xsl, then remove the old rewrite entries in the catalog as the root user:
[ -f /etc/xml/catalog ] && sed -i '/rewrite/d' /etc/xml/catalog

if [ ! -d /etc/xml ]; then install -v -m755 -d /etc/xml; fi &&
if [ ! -f /etc/xml/catalog ]; then
    xmlcatalog --noout --create /etc/xml/catalog
fi &&

xmlcatalog --noout --add "rewriteSystem" \
           "http://cdn.docbook.org/release/xsl-nons/$DOCBOOK_VERSION" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteSystem" \
           "https://cdn.docbook.org/release/xsl-nons/$DOCBOOK_VERSION" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteURI" \
           "http://cdn.docbook.org/release/xsl-nons/$DOCBOOK_VERSION" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteURI" \
           "https://cdn.docbook.org/release/xsl-nons/$DOCBOOK_VERSION" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteSystem" \
           "http://cdn.docbook.org/release/xsl-nons/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteSystem" \
           "https://cdn.docbook.org/release/xsl-nons/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteURI" \
           "http://cdn.docbook.org/release/xsl-nons/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteURI" \
           "https://cdn.docbook.org/release/xsl-nons/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteSystem" \
           "http://docbook.sourceforge.net/release/xsl/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION" \
    /etc/xml/catalog &&

xmlcatalog --noout --add "rewriteURI" \
           "http://docbook.sourceforge.net/release/xsl/current" \
           "/usr/share/xml/docbook/xsl-stylesheets-nons-$DOCBOOK_VERSION" \
    /etc/xml/catalog

update_version_list $PKG_DOCBOOK_XSL_NONS
