DESCRIPTION="The DocBook SGML DTD package contains document type definitions for verification of SGML data files against the DocBook rule set."

EXT_VERSION=3.1

unzip ../$(basename $PKG_DOCBOOK3_DTD)

sed -i -e '/ISO 8879/d' \
       -e 's|DTDDECL "-//OASIS//DTD DocBook V3.1//EN"|SGMLDECL|g' \
       docbook.cat

# As root:
install -v -d -m755 /usr/share/sgml/docbook/sgml-dtd-${EXT_VERSION}
chown -R root:root .
install -v docbook.cat /usr/share/sgml/docbook/sgml-dtd-${EXT_VERSION}/catalog
cp -v -af *.dtd *.mod *.dcl /usr/share/sgml/docbook/sgml-dtd-${EXT_VERSION}

install-catalog --add /etc/sgml/sgml-docbook-dtd-${EXT_VERSION}.cat \
    /usr/share/sgml/docbook/sgml-dtd-${EXT_VERSION}/catalog

install-catalog --add /etc/sgml/sgml-docbook-dtd-${EXT_VERSION}.cat \
    /etc/sgml/sgml-docbook.cat

cat >> /usr/share/sgml/docbook/sgml-dtd-3.1/catalog << "EOF"
  -- Begin Single Major Version catalog changes --

PUBLIC "-//Davenport//DTD DocBook V3.0//EN" "docbook.dtd"

  -- End Single Major Version catalog changes --
EOF

update_version_list docbook3_dtd-$EXT_VERSION
