DESCRIPTION="D-Bus is a message bus system, a simple way for applications to talk to one another."
# D-Bus
# D-Bus is a message bus system, a simple way for applications to talk to one another. D-Bus supplies both a system daemon (for events such as "new hardware device added" or "printer queue changed") and a per-user-login-session daemon (for general IPC needs among user applications). Also, the message bus is built on top of a general one-to-one message passing framework, which can be used by any two applications to communicate directly (without going through the message bus daemon).

# Contents
# Installed Programs: dbus-cleanup-sockets, dbus-daemon, dbus-launch, dbus-monitor, dbus-run-session, dbus-send, dbus-test-tool, dbus-update-activation-environment, and dbus-uuidgen
# Installed Libraries: libdbus-1.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /etc/dbus-1, /usr/include/dbus-1.0, /usr/lib/dbus-1.0, /usr/share/dbus-1, /usr/share/doc/dbus-1.16.0, and /var/lib/dbus

# Short Descriptions
# dbus-cleanup-sockets - is used to remove leftover sockets in a directory
# dbus-daemon - is the D-Bus message bus daemon
# dbus-launch - starts dbus-daemon from a shell script
# dbus-monitor - monitors messages passing through a D-Bus message bus
# dbus-run-session - starts a session bus instance of dbus-daemon from a shell script and starts a specified program in that session
# dbus-send - sends a message to a D-Bus message bus
# dbus-test-tool - is a tool to help packages test D-Bus
# dbus-update-activation-environment - updates environment variables that will be set for D-Bus session services
# dbus-uuidgen - Generates a universally unique ID
# libdbus-1 - Contains API functions used to communicate with the D-Bus message bus

# Required
# None

# Recommended
# Xorg Libraries (for dbus-launch program)

# Recommended_Runtime
# None

# Optional
# Systemd-257.3 (runtime, for registering services launched by D-Bus session daemon as systemd user services); For the tests: D-Bus Python-1.3.2, PyGObject-3.50.0, and Valgrind-3.24.0; for documentation: Doxygen-1.13.2, xmlto-0.0.29, Ducktype, and Yelp Tools

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_DBUS .tar.xz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup --prefix=/usr          \
            --buildtype=release    \
            --wrap-mode=nofallback \
            .. &&
ninja

# As root:
ninja install

if [ -e /usr/share/doc/dbus ]; then
  rm -rf /usr/share/doc/dbus-$EXT_VERSION    &&
  mv -v  /usr/share/doc/dbus{,-$EXT_VERSION}
fi

#meson configure -D asserts=true -D intrusive_tests=true &&
#ninja test

cat > /etc/dbus-1/session-local.conf << "EOF"
<!DOCTYPE busconfig PUBLIC
 "-//freedesktop//DTD D-BUS Bus Configuration 1.0//EN"
 "http://www.freedesktop.org/standards/dbus/1.0/busconfig.dtd">
<busconfig>

  <!-- Search for .service files in /usr/local -->
  <servicedir>/usr/local/share/dbus-1/services</servicedir>

</busconfig>
EOF

# Start the D-Bus session daemon
if [[ ! -f ~/.xinitrc ]]; then
	echo "eval 'dbus-launch'" > ~/.xinitrc
	echo "export DBUS_SESSION_BUS_ADDRESS" >> ~/.xinitrc
else
	[[ $(cat ~/.xinitrc | grep "eval 'dbus-launch'") != "eval 'dbus-launch'" ]] && echo "eval 'dbus-launch'" >> ~/.xinitrc
	[[ $(cat ~/.xinitrc | grep "export DBUS_SESSION_BUS_ADDRESS") != "export DBUS_SESSION_BUS_ADDRESS" ]] && echo "export DBUS_SESSION_BUS_ADDRESS" >> ~/.xinitrc
fi
if [[ ! -f ~/.xsession ]]; then
	echo "eval 'dbus-launch'" > ~/.xsession
	echo "export DBUS_SESSION_BUS_ADDRESS" >> ~/.xsession
else
	[[ $(cat ~/.xinitrc | grep "eval 'dbus-launch'") != "eval 'dbus-launch'" ]] && echo "eval 'dbus-launch'" >> ~/.xsession
	[[ $(cat ~/.xinitrc | grep "export DBUS_SESSION_BUS_ADDRESS") != "export DBUS_SESSION_BUS_ADDRESS" ]] && echo "export DBUS_SESSION_BUS_ADDRESS" >> ~/.xsession
fi

# Kill the D-Bus session daemon
if [[ ! -f ~/.bash_logout ]]; then
	echo "kill $DBUS_SESSION_BUS_PID" > ~/.bash_logout
else
	[[ $(cat ~/.xinitrc | grep "kill $DBUS_SESSION_BUS_PID") != "kill $DBUS_SESSION_BUS_PID" ]] && echo "kill $DBUS_SESSION_BUS_PID" >> ~/.bash_logout
fi

update_version_list $PKG_DBUS
