DESCRIPTION="The Cython package provides a compiler for writing C extensions for the Python language."
# Cython Python Module
# The Cython package provides a compiler for writing C extensions for the Python language.

# Contents
# Installed Programs: cygdb, cython, and cythonize
# Installed Libraries: None
# Installed Directory: /usr/lib/python3.13/site-packages/Cython, /usr/lib/python3.13/site-packages/Cython-3.0.12.dist-info, and /usr/lib/python3.13/site-packages/pyximport

# Short Descriptions
# mako-render - renders a template

# Required
# Python3, cython-3.0.12 and libyaml-0.2.5

# Recommended
# none

# Optional
# pytest-8.3.5 (for testing)

pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD

pip3 install --no-index --find-links dist --no-user Cython

# -w dist: builds the appropriate "wheel" for this module in the directory dist.
# --no-build-isolation: tells pip3 to run the build in the system environment instead of creating a temporary build environment.
# --no-deps: prevents pip3 from building wheels for the project's dependencies.
# --no-index: ignores the package index (only looking at --find-links URLs instead).
# --find-links dist: looks for links to archives such as wheel (.whl) files in the directory dist.
# --no-cache-dir: disables the cache to prevent a warning when installing as the root user.
# --no-user: Prevent mistakenly running the install command as a non-root user.
# --upgrade: Upgrade the package to the newest available version. This option is used with the install command if a version of the package is already installed.
# --force-reinstall: Reinstall the package even if it is up-to-date. This option is used with the install command if reinstalling the package or reverting to an earlier version of the package.
# --no-deps: Do not install package dependencies. This option may be needed with the --upgrade or --force-reinstall options.

update_version_list $PKG_CYTHON_PY
