DESCRIPTION="The cURL package contains an utility and a library used for transferring files with URL syntax to network protocols"
# cURL
# The cURL package contains an utility and a library used for transferring files with URL syntax to any of the following protocols: DICT, FILE, FTP, FTPS, GOPHER, GOPHERS, HTTP, HTTPS, IMAP, IMAPS, LDAP, LDAPS, MQTT, POP3, POP3S, RTSP, SMB, SMBS, SMTP, SMPTS, TELNET, and TFTP. Its ability to both download and upload files can be incorporated into other programs to support functions like streaming media.

# Contents
# Installed Programs: curl and curl-config
# Installed Libraries: libcurl.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/curl and /usr/share/doc/curl-8.12.1

# Short Descriptions
# curl - is a command line tool for transferring files with URL syntax
# curl-config - prints information about the last compile, like libraries linked to and prefix setting
# libcurl.so - provides the API functions required by curl and other programs

# Required
# None

# Recommended
# libpsl-0.21.5, make-ca-1.15

# Optional
# Brotli-1.1.0, c-ares-1.34.4, GnuTLS-3.8.9, libidn2-2.3.7, libssh2-1.11.1, MIT Kerberos V5-1.21.3, nghttp2-1.64.0, OpenLDAP-2.6.9, Samba-4.21.4 (runtime, for NTLM authentication), gsasl, impacket, libmetalink, librtmp, ngtcp2, quiche, and SPNEGO

# Optional_Documentation
# none

# Optional_Testing
# Apache-2.4.63 and stunnel-5.74 (for the HTTPS and FTPS tests), OpenSSH-9.9p2, and Valgrind-3.24.0 (this will slow the tests down and may cause failures)

EXT_VERSION=$((basename $PKG_CURL .tar.xz) | cut -d "-" -f 2)

./configure --prefix=/usr                           \
            --disable-static                        \
            --with-openssl                          \
            --enable-threaded-resolver              \
            --with-ca-path=/etc/ssl/certs
# --disable-static: This switch prevents installation of static versions of the libraries.
# --with-ca-path=/etc/ssl/certs: This switch sets the location of the BLFS Certificate Authority store.
# --with-openssl: This parameter chooses OpenSSL as SSL/TLS implementation. This option is not needed if --with-gnutls is selected instead.
# --with-gssapi: This parameter adds Kerberos 5 support to libcurl.
# --with-gnutls: Use this switch to build with GnuTLS support instead of OpenSSL for SSL/TLS.
# --with-ca-bundle=/etc/pki/tls/certs/ca-bundle.crt: Use this switch instead of --with-ca-path if building with GnuTLS support instead of OpenSSL for SSL/TLS.
# --with-libssh2: This parameter adds SSH support to cURL. This is disabled by default.
# --enable-ares: This parameter adds support for DNS resolution through the c-ares library.
# find docs ... -exec rm {} \;: This command removes Makefiles and man files from the documentation directory that would otherwise be installed by the commands that follow.

make

# As root:
make install

rm -rf docs/examples/.deps

find docs \( -name Makefile\* -o  \
             -name \*.1       -o  \
             -name \*.3       -o  \
             -name CMakeLists.txt \) -delete &&

cp -v -R docs -T /usr/share/doc/curl-$EXT_VERSION

if $MULTILIB
then
	rm -rf *
	# export CFLAGS="-m32"
	# export LDFLAGS="-m32"
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --prefix=/usr 				\
				--libdir=/usr/lib32			\
				--host=i686-pc-linux-gnu	\
				--disable-static 			\
				--with-openssl				\
				--enable-threaded-resolver	\
				--with-ca-path=/etc/ssl/certs
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	# export CFLAGS="-mx32"
	# export LDFLAGS="-mx32"
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure --prefix=/usr 					\
				--libdir=/usr/libx32			\
				--host=x86_64-pc-linux-gnux32	\
				--disable-static				\
				--with-openssl					\
				--enable-threaded-resolver		\
				--with-ca-path=/etc/ssl/certs
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_CURL
