DESCRIPTION="The Common Unix Printing System (CUPS) is a print spooler and associated utilities."
# Cups
# The Common Unix Printing System (CUPS) is a print spooler and associated utilities. It is based on the "Internet Printing Protocol" and provides printing services to most PostScript and raster printers. 

# Contents
# Installed Programs: cancel, cupsaccept, cups-config, cupsctl, cupsd, cupsdisable, cupsenable, cupsfilter, cupsreject, cupstestppd, ippeveprinter, ippfind, ipptool, lp, lpadmin, lpc, lpinfo, lpmove, lpoptions, lpq, lpr, lprm, lpstat, ppdc, ppdhtml, ppdi, ppdmerge, and ppdpo
# Installed Libraries: libcupsimage.so and libcups.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /etc/cups, /usr/{include,lib,share}/cups, /usr/share/doc/cups-2.4.11, /run/cups, and /var/{cache,log,spool}/cups

# Short Descriptions
# cancel - cancels existing print jobs from the print queues
# cupsaccept - accepts jobs sent to a destination
# cups-config - is a Cups program configuration utility
# cupsctl - updates or queries the cupsd.conf file for a server
# cupsd - is the scheduler for the Common Unix Printing System
# cupsdisable - stops printers and classes
# cupsenable - starts printers and classes
# cupsfilter - is a front-end to the Cups filter subsystem which allows you to convert a file to a specific format
# cupsreject - rejects jobs sent to a destination
# cupstestppd - tests the conformance of PPD files
# ippeveprinter - is an IPP Everywhere printer for CUPS
# ippfind - finds Internet Printing Protocol printers
# ipptool - sends IPP requests to the specified URI and tests and/or displays the results
# lp - submits files for printing or alters a pending job
# lpadmin - configures printer and class queues provided by Cups
# lpc - provides limited control over printer and class queues provided by Cups
# lpinfo - lists the available devices or drivers known to the Cups server
# lpmove - moves the specified job to a new destination
# lpoptions - displays or sets printer options and defaults
# lpq - shows the current print queue status on the named printer
# lpr - submits files for printing
# lprm - cancels print jobs that have been queued for printing
# lpstat - displays status information about the current classes, jobs, and printers
# ppdc - compiles PPDC source files into one or more PPD files
# ppdhtml - reads a driver information file and produces a HTML summary page that lists all of the drivers in a file and the supported options
# ppdi - imports one or more PPD files into a PPD compiler source file
# ppdmerge - merges two or more PPD files into a single, multi-language PPD file
# ppdpo - extracts UI strings from PPDC source files and updates either a GNU gettext or Mac OS X strings format message catalog source file for translation
# libcups.so - contains the Cups API functions

# Required
# GnuTLS-3.8.9, cups-filters-2.0.1 (Post Install)

# Recommended
# colord-1.4.7, dbus-1.16.0, libusb-1.0.27, Linux-PAM-1.7.0, and xdg-utils-1.2.1

# Recommended_Runtime
# None

# Optional
# Avahi-0.8, libpaper-2.2.6, MIT Kerberos V5-1.21.3, PHP-8.4.4, and Python2, Gutenprint-5.3.4 and hplip (HP printers)(Post Install)

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_CUPS -source.tar.gz | cut -d "-" -f 2) 

#cat /boot/config-$(uname -r) | grep CONFIG_USB_SUPPORT == CONFIG_USB_SUPPORT=y
#cat /boot/config-$(uname -r) | grep CONFIG_USB_PRINTER == CONFIG_USB_PRINTER=y
#cat /boot/config-$(uname -r) | grep CONFIG_PARPORT == CONFIG_USB_SUPPORT=y
#cat /boot/config-$(uname -r) | grep CONFIG_PARPORT_PC == CONFIG_USB_SUPPORT=y
#cat /boot/config-$(uname -r) | grep CONFIG_PRINTER == CONFIG_USB_SUPPORT=y

[[ $(cat /etc/group | grep lpadmin) == "" ]] && groupadd -g 19 lpadmin

[[ $(cat /etc/passwd | grep lp:) == "" ]] && useradd -c "Print Service User" -d /var/spool/cups -g lp -s /bin/false -u 9 lp

usermod -a -G lpadmin root

# sed -i 's#@CUPS_HTMLVIEW@#firefox#' desktop/cups.desktop.in



./configure --libdir=/usr/lib            \
            --with-rundir=/run/cups      \
            --with-system-groups=lpadmin \
            --with-docdir=/usr/share/cups/doc-$EXT_VERSION
make

# As root:
make install &&
ln -svnf ../cups/doc-2.4.11 /usr/share/doc/cups-$EXT_VERSION

echo "ServerName /run/cups/cups.sock" > /etc/cups/client.conf

update_version_list $PKG_CUPS
