DESCRIPTION="The CrackLib package contains a library used to enforce strong passwords by comparing user selected passwords to words in chosen word lists."
# CrackLib
# The CrackLib package contains a library used to enforce strong passwords by comparing user selected passwords to words in chosen word lists.

# Contents
# Installed Programs: cracklib-check, cracklib-format, cracklib-packer, cracklib-unpacker, cracklib-update, and create-cracklib-dict
# Installed Libraries: libcrack.so and _cracklib.so (Python module)
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/lib/cracklib, /usr/share/dict, and /usr/share/cracklib

# Short Descriptions
# cracklib-check - is used to determine if a password is strong
# cracklib-format - is used to format text files (lowercases all words, removes control characters and sorts the lists)
# cracklib-packer - creates a database with words read from standard input
# cracklib-unpacker - displays on standard output the database specified
# create-cracklib-dict - is used to create the CrackLib dictionary from the given word list(s)
# libcrack.so - provides a fast dictionary lookup method for strong password enforcement

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_CRACKLIB .tar.xz | cut -d "-" -f 2) 

CPPFLAGS+=" -I $(ls -d /usr/include/python*)" \
./configure --prefix=/usr               \
            --disable-static            \
            --with-default-dict=/usr/lib/cracklib/pw_dict &&
make

# As root:
make install

xzcat ../$(basename $PKG_CRACKLIBWORDS) \
                       > /usr/share/dict/cracklib-words       &&
ln -v -sf cracklib-words /usr/share/dict/words                &&
echo $(hostname) >>      /usr/share/dict/cracklib-extra-words &&
install -v -m755 -d      /usr/lib/cracklib                    &&

create-cracklib-dict     /usr/share/dict/cracklib-words \
                         /usr/share/dict/cracklib-extra-words

# make test
# python3 -c 'import cracklib; cracklib.test()'

update_version_list $PKG_CRACKLIB
