DESCRIPTION="Colord is a system service that makes it easy to manage, install, and generate color profiles."

EXT_VERSION=$(basename $PKG_COLORD .tar.gz | cut -d "-" -f 2) 

patch -Np1 -i ../colord-1.4.7-upstream_fixes-1.patch

[[ $(cat /etc/group | grep colord) == "" ]] && groupadd -g 71 colord

[[ $(cat /etc/passwd | grep colord:) == "" ]] && useradd -c "Color Daemon Owner" -d /var/lib/colord -u 71 -g colord -s /bin/false colord

[[ $(command -v valac) != "" ]] && OPTIONS="-D vapi=true" || OPTIONS=""
[[ $(command -v systemctl) != "" ]] && OPTIONS="$OPTIONS -D systemd=true"
#[ -f /etc/bash_completion ] && OPTIONS="$OPTIONS -D bash_completion=true" || OPTIONS="$OPTIONS -D bash_completion=false"	#Broken
OPTIONS="$OPTIONS -D bash_completion=false"
[[ $(command -v gtkdocize) != "" ]] && OPTIONS="$OPTIONS -D docs=true" || OPTIONS="$OPTIONS -D docs=false"

mkdir build &&
cd    build &&

meson setup ..                  \
      --prefix=/usr             \
      --buildtype=release       \
      -D daemon_user=colord     \
      -D libcolordcompat=true   \
      -D argyllcms_sensor=false \
      -D man=false              \
	  $OPTIONS
ninja

if [[ $(command -v xslt-config) != "" ]] && [ -d /usr/share/xml/docbook/xsl-stylesheets-* ] && [ -d /usr/share/xml/docbook/schema/dtd/5.* ]; then
	sed -e '/class="manual"/i<refmiscinfo class="source">colord</refmiscinfo>' \
		-i ../man/*.xml
	meson configure -D man=true
	ninja
fi

# As root:
ninja install

update_version_list $PKG_COLORD
