DESCRIPTION="Modern toolset used for generating Makefiles"

sed -i '/"lib64"/s/64//' Modules/GNUInstallDirs.cmake

VERSION_CMAKE=$(basename $PKG_CMAKE .tar.gz | cut -d "-" -f 2) 

[[ $(command -v qmake) != "" ]] && QT_OPTIONS="--qt-gui" || QT_OPTIONS=""
[[ $(command -v curl) == "" ]] && CURL_OPTIONS="--no-system-curl" || CURL_OPTIONS=""
[[ $(command -v bsdunzip) == "" ]] && ARCHIVE_OPTIONS="--no-system-libarchive" || ARCHIVE_OPTIONS=""
[ ! -e /lib/libuv.so ] && UV_OPTIONS="--no-system-libuv" || UV_OPTIONS=""
[ ! -e /lib/libnghttp2.so ] && HTTP_OPTIONS="--no-system-nghttp2" || HTTP_OPTIONS=""

./bootstrap --prefix=/usr        \
            --system-libs        \
            --mandir=/share/man  \
            --no-system-jsoncpp  \
            --no-system-cppdap   \
            --no-system-librhash \
			$QT_OPTIONS $CURL_OPTIONS \
			$ARCHIVE_OPTIONS $UV_OPTIONS $HTTP_OPTIONS \
            --docdir=/share/doc/cmake-$VERSION_CMAKE
# --system-libs: This switch forces the build system to link against the system installed version for all needed libraries but those explicitly specified via a --no-system-* option.
# --no-system-jsoncpp and --no-system-cppdap: These switches remove the JSON-C++ library from the list of system libraries. A bundled version of that library is used instead.
# --no-system-librhash: This switch removes the librhash library from the list of system libraries used. A bundled version of that library is used instead.
# --no-system-{curl,libarchive,libuv,nghttp2}: Use the corresponding option in the list for the bootstrap if one of the recommended dependencies is not installed. A bundled version of the dependency will be used instead.
# --qt-gui: This switch enables building the Qt-based GUI for CMake.
# --parallel=: This switch enables performing the CMake bootstrap with multiple jobs at one time.
			
make

# As root:
make install

update_version_list $PKG_CMAKE
