DESCRIPTION="Modern toolset used for generating Makefiles"
# cmake

# The CMake package contains a modern toolset used for generating Makefiles. It is a successor of the auto-generated configure script and aims to be platform- and 
# compiler-independent. A significant user of CMake is KDE since version 4.

# Contents
# Installed Programs: ccmake, cmake, cmake-gui (optional), cpack, and ctest
# Installed Libraries: None
# Installed Directories: /usr/share/cmake-3.28 and /usr/share/doc/cmake-3.28.3

# Short Descriptions
# ccmake - is a curses based interactive frontend to cmake
# cmake - is the makefile generator
# cmake-gui - (optional) is the Qt-based frontend to cmake
# cpack - is the CMake packaging program
# ctest - is a testing utility for cmake-generated build trees

sed -i '/"lib64"/s/64//' Modules/GNUInstallDirs.cmake
# sed ... Modules/GNUInstallDirs.cmake: This command disables applications using cmake from attempting to install files in /usr/lib64/.

[[ $(command -v qmake) != "" ]] && QT_OPTIONS="--qt-gui" || QT_OPTIONS=""
[[ $(command -v curl) == "" ]] && CURL_OPTIONS="--no-system-curl" || CURL_OPTIONS=""
[[ $(command -v bsdunzip) == "" ]] && ARCHIVE_OPTIONS="--no-system-libarchive" || ARCHIVE_OPTIONS=""
[ ! -e /lib/libuv.so ] && UV_OPTIONS="--no-system-libuv" || UV_OPTIONS=""
[ ! -e /lib/libnghttp2.so ] && HTTP_OPTIONS="--no-system-nghttp2" || HTTP_OPTIONS=""

./bootstrap --prefix=/usr        \
            --system-libs        \
            --mandir=/share/man  \
            --no-system-jsoncpp  \
            --no-system-cppdap   \
            --no-system-librhash \
			$QT_OPTIONS $CURL_OPTIONS \
			$ARCHIVE_OPTIONS $UV_OPTIONS $HTTP_OPTIONS \
            --docdir=/share/doc/cmake-$VERSION_CMAKE
# --system-libs: This switch forces the build system to link against the system installed version for all needed libraries but those explicitly specified via a --no-system-* option.
# --no-system-jsoncpp and --no-system-cppdap: These switches remove the JSON-C++ library from the list of system libraries. A bundled version of that library is used instead.
# --no-system-librhash: This switch removes the librhash library from the list of system libraries used. A bundled version of that library is used instead.
# --no-system-{curl,libarchive,libuv,nghttp2}: Use the corresponding option in the list for the bootstrap if one of the recommended dependencies is not installed. A bundled version of the dependency will be used instead.
# --qt-gui: This switch enables building the Qt-based GUI for CMake.
# --parallel=: This switch enables performing the CMake bootstrap with multiple jobs at one time.
			
make

# As root:
make install

update_version_list $PKG_CMAKE
