DESCRIPTION="The CDParanoia package contains a CD audio extraction tool."
# CDParanoia-III
# The CDParanoia package contains a CD audio extraction tool. This is useful for extracting .wav files from audio CDs. A CDDA capable CDROM drive is needed. Practically all drives supported by Linux can be used. 

# Contents
# Installed Programs: cdparanoia
# Installed Libraries: libcdda_interface.so and libcdda_paranoia.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# cdparanoia - is used for 'ripping' an audio-cd. Ripping is the process of digitally extracting music from an audio CD
# libcdda_interface - contains functions used by cdparanoia, as well as other packages, which can automatically identify if a CD device is CDDA compatible
# libcdda_paranoia - contains functions used by cdparanoia, as well as other packages, which provide data verification, synchronization, error handling and scratch reconstruction capability

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_CDPARANOIA_III .src.tgz | cut -d "-" -f 3) 

[[ -f ../$(basename $PATCH_CDPARANOIA_III) ]] && patch -Np1 -i ../$(basename $PATCH_CDPARANOIA_III)
./configure --prefix=/usr --mandir=/usr/share/man
make -j1

# As root:
make install &&
chmod -v 755 /usr/lib/libcdda_*.so.0.$EXT_VERSION
rm -fv /usr/lib/libcdda_*.a

update_version_list $PKG_CDPARANOIA_III
