DESCRIPTION="The cargo-c package creates a cargo subcommand to build and install C-ABI compatible dynamic and static libraries."
# C-bindgen
# C-bindgen can be used to generate C bindings for Rust code.

# Contents
# Installed Programs: cbindgen
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# cbindgen - generates C bindings for Rust code

# Required
# rustc-1.85.0

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_CARGO_C .tar.gz | cut -d "-" -f 3) 

source /etc/profile.d/rustc.sh

if [[ $(ping -c 1 8.8.8.8 | grep "Destination Net Unreachable") == "" ]]; then
	curl -LO https://github.com/lu-zero/cargo-c/releases/download/v0.10.11/Cargo.lock
	[ ! -e /usr/include/libssh2.h ] || export LIBSSH2_SYS_USE_PKG_CONFIG=1
	[ ! -e /usr/include/sqlite3.h ] || export LIBSQLITE3_SYS_USE_PKG_CONFIG=1
	cargo build --release
else
	rm -r *
	curl -LO https://repo.dillonsociety.com/pub/DSLsq/portholes/cargo_c-$EXT_VERSION-offline.tar.gz
	tar -xvf cargo_c-$EXT_VERSION-offline.tar.gz --strip-components=1
	[ ! -e /usr/include/libssh2.h ] || export LIBSSH2_SYS_USE_PKG_CONFIG=1
	[ ! -e /usr/include/sqlite3.h ] || export LIBSQLITE3_SYS_USE_PKG_CONFIG=1
	cargo build --release --offline
fi

# cargo test --release

# As root:
install -vm755 target/release/cargo-{capi,cbuild,cinstall,ctest} /usr/bin/

update_version_list $PKG_CARGO_C
