DESCRIPTION="Cbindgen can be used to generate C bindings for Rust code."

EXT_VERSION=$(basename $PKG_C_BINDGEN .tar.gz | cut -d "-" -f 2) 

source /etc/profile.d/rustc.sh

if [[ $(ping -c 1 8.8.8.8 | grep "Destination Net Unreachable") == "" ]]; then
	rm -rf ~/.cargo/registry/index/* ~/.cargo/.package-cache
	cargo build --release
else
	rm -r *
	curl -LO https://repo.dillonsociety.com/pub/DSLsq/portholes/cbindgen-$EXT_VERSION-offline.tar.gz
	tar -xvf cbindgen-$EXT_VERSION-offline.tar.gz --strip-components=1
	cargo build --release --offline
fi

# cargo test --release

# As root:
install -Dm755 target/release/cbindgen /usr/bin/

update_version_list c_bindgen-$EXT_VERSION
