DESCRIPTION="Brotli provides a general-purpose lossless compression algorithm that compresses data using a combination of a modern variant of the LZ77 algorithm, Huffman coding and 2nd order context modeling."
# brotli
# Brotli provides a general-purpose lossless compression algorithm that compresses data using a combination of a modern variant of the LZ77 algorithm, Huffman coding and 2nd order context modeling. Its libraries are particularly used for WOFF2 fonts on webpages. 

# Contents
# Installed Programs: libbrotlicommon.so, libbrotlidec.so, and libbrotlienc.so
# Installed Libraries: libbrotlicommon.so, libbrotlidec.so, and libbrotlienc.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/brotli and /usr/lib/python3.13/site-packages/Brotli-1.1.0.dist-info (if you built and installed the Python3 bindings)

# Short Descriptions
# brotli - can compress or decompress files, or test the integrity of compressed files
# libbrotlicommon{-static.a,.so} - is the Brotli common dictionary library
# libbrotlidec{-static.a,.so} - is the Brotli decoder library
# libbrotlienc{-static.a,.so} - is the Brotli common encoder library

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_BROTLI .tar.gz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

cmake -D CMAKE_INSTALL_PREFIX=/usr \
      -D CMAKE_BUILD_TYPE=Release  \
      ..  &&
make

# As root:
make install

cd .. &&
sed "/c\/.*\.[ch]'/d;\
     /include_dirs=\[/\
     i libraries=['brotlicommon','brotlidec','brotlienc']," \
    -i setup.py &&
pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD

pip3 install --no-index --find-links dist --no-user Brotli

update_version_list $PKG_BROTLI
