DESCRIPTION="The BlueZ package contains the Bluetooth protocol stack for Linux."

EXT_VERSION=$(basename $PKG_BLUEZ .tar.xz | cut -d "-" -f 2) 

./configure --prefix=/usr         \
            --sysconfdir=/etc     \
            --localstatedir=/var  \
            --disable-manpages    \
            --enable-library 
make

# As root:
make install &&
ln -svf ../libexec/bluetooth/bluetoothd /usr/sbin

install -v -dm755 /etc/bluetooth &&
install -v -m644 src/main.conf /etc/bluetooth/main.conf

install -v -dm755 /usr/share/doc/bluez-$EXT_VERSION
install -v -m644 doc/*.txt /usr/share/doc/bluez-$EXT_VERSION

update_version_list bluez-$EXT_VERSION
