DESCRIPTION="The Apache Portable Runtime Utility Library provides a predictable and consistent interface to underlying client library interfaces."
# Apr-Util
# The Apache Portable Runtime Utility Library provides a predictable and consistent interface to underlying client library interfaces. This application programming interface assures predictable if not identical behavior regardless of which libraries are available on a given platform.

# Contents
# Installed Programs: apu-1-config
# Installed Libraries: libaprutil-1.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/lib/apr-util-1

# Short Descriptions
# apu-1-config - is an APR-util script designed to allow easy command line access to APR-util configuration parameters
# libaprutil-1.so - contains functions that provide a predictable and consistent interface to underlying client library interfaces

# Required
# Apr-1.7.5

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# FreeTDS, MariaDB-11.4.5 or MySQL, OpenLDAP-2.6.9, PostgreSQL-17.4, SQLite-3.49.1, unixODBC-2.3.12, and Berkeley DB (deprecated)

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_APR_UTIL .tar.bz2 | cut -d "-" -f 3) 

./configure --prefix=/usr       \
            --with-apr=/usr     \
            --with-gdbm=/usr    \
            --with-openssl=/usr \
            --with-crypto &&
make

# As root:
make install

update_version_list $PKG_APR_UTIL
