DESCRIPTION="The appstream-glib provides GObjects and helper methods to make it easy to read and write AppStream metadata."
# AppStream-glib
# The appstream-glib provides GObjects and helper methods to make it easy to read and write AppStream metadata. It also provides a simple DOM (Document Object Model) implementation that makes it easy to edit nodes and convert to and from the standardized XML representation.

# Contents
# Installed Programs: appstream-builder, appstream-compose, and appstream-util
# Installed Libraries: libappstream-glib.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/libappstream-glib, /usr/lib/asb-plugins-5, and /usr/share/installed-tests/appstream-glib

# Short Descriptions
# appstream-builder - builds AppStream metadata
# appdata-compose - generates AppStream metadata
# appstream-util - Is a management tool for appstream-builder
# libappstream-glib.so - contains the API functions

# Required
# cURL-8.12.1, gdk-pixbuf-2.42.12, GTK-3.24.48, and libarchive-3.7.7

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# docbook-xml-4.5, docbook-xsl-nons-1.79.2, GTK-Doc-1.34.0, libxslt-1.1.42, and libyaml-0.2.5

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_APPSTREAM_GLIB .tar.xz | cut -d "-" -f 3) 

mkdir build &&
cd    build &&

meson setup ..            \
      --prefix=/usr       \
      --buildtype=release \
      -D rpm=false        &&
ninja

# As root:
ninja install 

update_version_list $PKG_APPSTREAM_GLIB
