DESCRIPTION="The AppStream package contains a library and tool that is useful for retrieving software metadata and making it easily accessible to programs which need it."
# AppStream
# The AppStream package contains a library and tool that is useful for retrieving software metadata and making it easily accessible to programs which need it. 

# Contents
# Installed Programs: appstreamcli
# Installed Libraries: libappstream.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/appstream, /usr/share/doc/appstream-1.0.4, and /usr/share/installed-tests/appstream

# Short Descriptions
# appstreamcli - queries information from AppStream metadata and from the AppStream component index
# libappstream.so - contains functions that handle AppStream metadata queries and request information from the AppStream component index

# Required
# cURL-8.12.1, itstool-2.0.7, libxml2-2.13.6, libxmlb-0.3.21, and libyaml-0.2.5

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# Gi-DocGen-2025.3, Qt-6.8.2, DAPS, and libstemmer

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_APPSTREAM .tar.xz | cut -d "-" -f 2) 

cd $(basename $PKG_APPSTREAM .tar.xz)

mkdir build
cd    build

OPTIONS=""
[[ $(command -v designer) != "" ]] && OPTIONS="-D qt=true"

meson setup --prefix=/usr       \
            --buildtype=release \
            -D apidocs=false    \
            -D stemming=false   \
			$OPTIONS ..
ninja

# As root:
ninja install
mv -v /usr/share/doc/appstream{,-$EXT_VERSION}

install -vdm755 /usr/share/metainfo
cat > /usr/share/metainfo/org.linuxfromscratch.lfs.xml << EOF
<?xml version="1.0" encoding="UTF-8"?>
<component type="operating-system">
  <id>org.linuxfromscratch.lfs</id>
  <name>Linux From Scratch</name>
  <summary>A customized Linux system built entirely from source</summary>
  <description>
    <p>
      Linux From Scratch (LFS) is a project that provides you with
      step-by-step instructions for building your own customized Linux
      system entirely from source.
    </p>
  </description>
  <url type="homepage">https://www.linuxfromscratch.org/lfs/</url>
  <metadata_license>MIT</metadata_license>
  <developer id='linuxfromscratch.org'>
    <name>The Linux From Scratch Editors</name>
  </developer>

  <releases>
    <release version="12.3" type="release" date="2025-03-05">
      <description>
        <p>The development snapshot of the next LFS version.</p>
      </description>
    </release>

    <release version="12.2" type="stable" date="2024-09-01">
      <description>
        <p>Now contains Binutils 2.43.1, GCC-14.2.0, Glibc-2.40,
        and Linux kernel 6.10.</p>
      </description>
    </release>
  </releases>
</component>
EOF

update_version_list $PKG_APPSTREAM
