DESCRIPTION="The ALSA Plugins package contains plugins for various audio libraries and sound servers."

EXT_VERSION=$(basename $PKG_ALSA_PLUGINS .tar.bz2 | cut -d "-" -f 3) 

./configure --sysconfdir=/etc --disable-libav
make

# As root:
make install

if $MULTILIB
then
	make distclean
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --libdir=/usr/lib32 		\
				--sysconfdir=/etc   		\
				--disable-libav     		\
				--host=i686-pc-linux-gnu
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make distclean
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure --libdir=/usr/libx32			\
				--sysconfdir=/etc   			\
				--disable-libav     			\
				--host=x86_64-pc-linux-gnux32 
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_ALSA_PLUGINS
