DESCRIPTION="The ALSA Library package contains the ALSA library used by programs (including ALSA Utilities) requiring access to the ALSA sound interface."
# ALSA Library
# The ALSA Library package contains the ALSA library used by programs (including ALSA Utilities) requiring access to the ALSA sound interface. 

# Contents
# Installed Programs: aserver
# Installed Libraries: libasound.so and libatopology.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/alsa, /usr/share/alsa and /usr/share/doc/alsa-lib-1.2.13

# Short Descriptions
# aserver - is the ALSA server
# libasound.so - contains the ALSA API functions
# libatopology.so - contains API functions for the ALSA topologies

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_ALSA_LIB .tar.bz2 | cut -d "-" -f 3) 

[[ $(cat /boot/config-$(uname -r) | grep "CONFIG_SOUND=y") == "" ]] && echo "Missing kernel option SOUND" && exit -1
[[ $(cat /boot/config-$(uname -r) | grep "CONFIG_SND=y") == "" ]] && echo "Missing kernel option SND" && exit -1

./configure &&
make

[[ $(command -v doxygen) ]] && make doc

# As root:
make install
[[ -f ../$(basename $CONF_ALSA_LIB) ]] && tar -C /usr/share/alsa --strip-components=1 -xf ../$(basename $CONF_ALSA_LIB)

if [[ $(command -v doxygen) ]]; then
	install -v -d -m755 /usr/share/doc/alsa-lib-$EXT_VERSION/html/search &&
	install -v -m644 doc/doxygen/html/*.* \
					/usr/share/doc/alsa-lib-$EXT_VERSION/html &&
	install -v -m644 doc/doxygen/html/search/* \
					/usr/share/doc/alsa-lib-$EXT_VERSION/html/search
fi

if $MULTILIB
then
	make distclean
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --libdir=/usr/lib32      	\
				--host=i686-pc-linux-gnu
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make distclean
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure --libdir=/usr/libx32			\
				--host=x86_64-pc-linux-gnux32 
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_ALSA_LIB
