DESCRIPTION="The AccountsService package provides a set of D-Bus interfaces for querying and manipulating user account information."

EXT_VERSION=$(basename $PKG_ACCOUNTSSERVICE .tar.xz | cut -d "-" -f 2) 

[[ $(command -v valac) == "" ]] && OPTION="-D vapi=false" | OPTION=""
[[ $(command -v gtkdocize) != "" ]] && OPTION="$OPTION -D gtk_doc=true"
[[ $(command -v xmlto) != "" ]] && OPTION="$OPTION -D docbook=true"

[ ! -d /usr/lib/python*/site-packages/python_dbusmock-* ] && mv tests/dbusmock{,-tests}

sed -e '/accounts_service\.py/s/dbusmock/dbusmock-tests/' \
    -e 's/assertEquals/assertEqual/'                      \
    -i tests/test-libaccountsservice.py

mkdir build &&
cd    build &&

meson setup ..            \
      --prefix=/usr       \
      --buildtype=release \
      -D admin_group=adm \
	  $OPTION

grep 'print_indent'     ../subprojects/mocklibc-1.0/src/netgroup.c \
     | sed 's/ {/;/' >> ../subprojects/mocklibc-1.0/src/netgroup.h &&
sed -i '1i#include <stdio.h>'                                      \
    ../subprojects/mocklibc-1.0/src/netgroup.h

ninja

# As root:
ninja install

cat > /etc/polkit-1/rules.d/40-adm.rules << "EOF"
polkit.addAdminRule(function(action, subject) {
   return ["unix-group:adm"];
   });
EOF

update_version_list $PKG_ACCOUNTSSERVICE
